#ifndef _WB_MODULE_PRINTING_H_
#define _WB_MODULE_PRINTING_H_

#include "wb_module_printing.h"

#include "interfaces/plugin.h"

#define WBModule_VERSION "1.0.0"


class WbPrintingImpl : public grt::ModuleImplBase, PluginInterfaceImpl
{
  typedef grt::ModuleImplBase super;

public:
  WbPrintingImpl(grt::CPPModuleLoader *ldr);

  DEFINE_INIT_MODULE(WBModule_VERSION, "MySQL AB", grt::ModuleImplBase,
    DECLARE_MODULE_FUNCTION(WbPrintingImpl::getPluginInfo),

    DECLARE_MODULE_FUNCTION(WbPrintingImpl::printToPDFFile),
    DECLARE_MODULE_FUNCTION(WbPrintingImpl::printToPSFile),
    DECLARE_MODULE_FUNCTION(WbPrintingImpl::printToPrinter)
    );

private:
  virtual grt::ListRef<app_Plugin> getPluginInfo();

  int printToPDFFile(model_DiagramRef view, const std::string &path);
  int printToPSFile(model_DiagramRef view, const std::string &path);

  int printToPrinter(model_DiagramRef view, const std::string &printer);
};

#endif
