#ifndef __ROUTINE_GROUP_EDITOR_H__
#define __ROUTINE_GROUP_EDITOR_H__

#include "DBObjectEditorBE.h"
#include "GrtTemplates.h"
#include "grtdb/editor_routinegroup.h"

#pragma make_public(::bec::RoutineGroupEditorBE)

namespace MySQL {
namespace Grt {
namespace Db {

public ref class RoutineGroupEditorBE : public DBObjectEditorBE
{
protected:
  RoutineGroupEditorBE(::bec::RoutineGroupEditorBE *inn)
    : DBObjectEditorBE(inn)
  {}

public:
  ::bec::RoutineGroupEditorBE *get_unmanaged_object()
  { return static_cast<::bec::RoutineGroupEditorBE *>(inner); }
  
  String^ get_routines_sql()
  { return CppStringToNative(get_unmanaged_object()->get_routines_sql()); }

  String^ get_routine_sql(MySQL::Grt::GrtValue^ routine)
  { return CppStringToNative(get_unmanaged_object()->get_routine_sql(db_RoutineRef::cast_from(routine->get_unmanaged_object()))); }

  void set_routines_sql(String ^query, bool sync)
  { get_unmanaged_object()->set_routines_sql(NativeToCppString(query), sync); }

  List<String^>^ get_routines_names()
  { return CppStringListToNative(get_unmanaged_object()->get_routines_names()); }

  void delete_routine_with_name(String^ name)
  { get_unmanaged_object()->delete_routine_with_name(NativeToCppString(name)); }

  void append_routine_with_id(String^ id)
  { get_unmanaged_object()->append_routine_with_id(NativeToCppString(id)); }

  String^ get_routine_name(String^ id)
  { return CppStringToNative(get_unmanaged_object()->get_routine_name(NativeToCppString(id))); }

  String^ get_name()
  { return CppStringToNative(get_unmanaged_object()->get_name()); }

  void set_name(String ^query)
  { get_unmanaged_object()->set_name(NativeToCppString(query)); }

  String^ get_comment()
  { return CppStringToNative(get_unmanaged_object()->get_comment()); }

  void set_comment(String ^query)
  { get_unmanaged_object()->set_comment(NativeToCppString(query)); }

  bool has_syntax_error() { return get_unmanaged_object()->has_syntax_error(); }
};

} // namespace Db
} // namespace Grt
} // namespace MySQL

#endif // __ROUTINE_GROUP_EDITOR_H__