/* 
 * Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "tut_stdafx.h"
// Dummy file.

#include "../stub_app.h"

namespace mforms {
namespace stub {


static std::list<std::string> directory_names;

static void scan_dir_names(const std::string &dir)
{
  GError *error = NULL;
  GDir *d = g_dir_open(dir.c_str(), 0, &error);
  if (d)
  {
    const char *f;
    while ((f = g_dir_read_name(d)))
    {
      if (g_file_test((dir+"/"+f).c_str(), G_FILE_TEST_IS_DIR))
      {
        directory_names.push_back(dir+"/"+f);
        scan_dir_names(dir+"/"+f);
      }
    }
    g_dir_close(d);
  }
  else
    g_warning("Unable to open dir %s: %s", dir.c_str(), error->message);
}

std::string __stdcall AppImpl::get_resource_path(App *app, const std::string &file)
{
  if (directory_names.empty())
  {
    scan_dir_names("data");
    scan_dir_names("images");
    scan_dir_names("modules");
  }
  
  if (file.empty())
    return "./";

  std::string f;
  for (std::list<std::string>::const_iterator i = directory_names.begin();
    i != directory_names.end(); ++i)
  {
    if (g_file_test((*i+"/"+file).c_str(), G_FILE_TEST_EXISTS))
      return *i+"/"+file;
  }

  if (f.empty())
     g_message("file %s not found", file.c_str());
  return f;
}


};};