/* 
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#include "tut_stdafx.h"

#include "../stub_app.h"
#include "../stub_button.h"
#include "../stub_radiobutton.h"
#include "../stub_mforms.h"
#include "../stub_checkbox.h"
#include "../stub_textentry.h"
#include "../stub_textbox.h"
#include "../stub_imagebox.h"
#include "../stub_label.h"
#include "../stub_selector.h"
#include "../stub_listbox.h"
#include "../stub_tabview.h"
#include "../stub_form.h"
#include "../stub_panel.h"
#include "../stub_box.h"
#include "../stub_table.h"
#include "../stub_progressbar.h"
#include "../stub_filechooser.h"
#include "../stub_scrollpanel.h"
#include "../stub_wizard.h"
#include "../stub_utilities.h"
#include "../stub_drawbox.h"
#include "../stub_menu.h"
#include "../stub_menuitem.h"
#include "../stub_splitter.h"
#include "../stub_grttreeview.h"
#include "../stub_treenodeview.h"
#include "../stub_codeeditor.h"
#include "../stub_toolbar.h"
#include "../stub_grid.h"
#include "mforms/dockingpoint.h"

class DockingPointDelegate : public mforms::DockingPointDelegate
{
  virtual std::string get_type() { return "MainWindow"; }
  virtual void dock_view(mforms::AppView *view, const std::string &arg1, int arg2)
  {
  }
  virtual bool select_view(mforms::AppView *view) { return false; }
  virtual void undock_view(mforms::AppView *view) {}
  virtual void set_view_title(mforms::AppView *view, const std::string &title) {}
  virtual void get_size(int *w, int *h) {}
};

DockingPointDelegate deleg;

boost::function<void (std::string)> mforms::stub::UtilitiesImpl::open_url_slot;

void ::mforms::stub::init()
{
  App::instantiate(&deleg, false);
#ifdef _WIN32
  AppImpl::init();
#endif
  ViewImpl::init();
  BoxImpl::init();
  FormImpl::init();
  ButtonImpl::init();
  RadioButtonImpl::init();
  CheckBoxImpl::init();
  TextEntryImpl::init();
  TextBoxImpl::init();
  LabelImpl::init();
  ImageBoxImpl::init();
  SelectorImpl::init();
  ListBoxImpl::init();
  PanelImpl::init();
  TabViewImpl::init();
  FileChooserImpl::init();
  ProgressBarImpl::init();
  TableImpl::init();
  ScrollPanelImpl::init();
  WizardImpl::init();
  UtilitiesImpl::init();
  DrawBoxImpl::init();
  SplitterImpl::init();
  MenuImpl::init();
  MenuItemImpl::init();
  GRTTreeViewImpl::init();
  CodeEditorImpl::init();
  ToolBarImpl::init();
  GridImpl::init();
  TreeNodeViewImpl::init();

  if (!getenv("QUIET"))
    puts("done setting up mforms stubs...");
}


void ::mforms::stub::check()
{
  mforms::ControlFactory *f= mforms::ControlFactory::get_instance();
  f->check_impl();
}


