/* 
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#include "tut_stdafx.h"

#include "../stub_treenode.h"

#include "base/string_utilities.h"

bool TreeNodeImpl::is_root() const
{
  return true;
};

void TreeNodeImpl::release(){}
void TreeNodeImpl::retain(){}

bool TreeNodeImpl::equals(const mforms::TreeNode &other)
{
  return true;
}

bool TreeNodeImpl::is_valid() const
{
  return true;
}
    
void TreeNodeImpl::set_icon_path(int column, const std::string &icon)
{
  set_string(column+1, icon);
}

void TreeNodeImpl::set_attributes(int column, const mforms::TreeNodeTextAttributes& attrs)
{
  mforms::TreeNodeTextAttributes attributes;

  while(_attributes.size() < (size_t)(column + 1))
    _attributes.push_back(attributes);

  attributes = attrs;
  _attributes[column] = attributes;
}


void TreeNodeImpl::set_string(int column, const std::string &value)
{
  while(_values.size() < (size_t)(column + 1))
    _values.push_back("");

  _values[column] = value;
}

void TreeNodeImpl::set_int(int column, int value){}
void TreeNodeImpl::set_long(int column, boost::int64_t value){}
void TreeNodeImpl::set_bool(int column, bool value){}

std::string TreeNodeImpl::get_string(int column) const
{
  return _values.size() > (size_t)column ? _values[column] : "";
}

int TreeNodeImpl::get_int(int column) const
{
  return 0;
}

boost::int64_t TreeNodeImpl::get_long(int column) const
{
  return 0;
}

bool TreeNodeImpl::get_bool(int column) const
{
  return true;
}
    
int TreeNodeImpl::count() const
{
  return _children.size();
}

std::vector<mforms::TreeNodeRef> TreeNodeImpl::add_child_nodes(int column, const std::vector<std::string> &column_values)
{
  std::vector<mforms::TreeNodeRef> result;

  for (std::vector<std::string>::const_iterator it = column_values.begin();
    it != column_values.end(); ++it)
  {
    TreeNodeImpl* child = new TreeNodeImpl();
    child->_parent = mforms::TreeNodeRef(this);
    _children.push_back(child);
    mforms::TreeNodeRef tmp(child);
    tmp->set_string(column, *it);
    result.push_back(tmp);
  }
  return result;
}

mforms::TreeNodeRef TreeNodeImpl::insert_child(int index)
{
  if (index == -1)
  {
    TreeNodeImpl* child = new TreeNodeImpl();
    child->_parent = mforms::TreeNodeRef(this);
    _children.push_back(child);

    return mforms::TreeNodeRef(child);
  }

  return mforms::TreeNodeRef();
}

void TreeNodeImpl::remove_from_parent()
{
  TreeNodeImpl* inner_parent = dynamic_cast<TreeNodeImpl*>(_parent.ptr());

  if (inner_parent)
  {
    if (std::find(inner_parent->_children.begin(), inner_parent->_children.end(), this) != inner_parent->_children.end())
    {
      inner_parent->_children.erase(std::find(inner_parent->_children.begin(), inner_parent->_children.end(), this));
    }
  }
}


mforms::TreeNodeRef TreeNodeImpl::get_child(int index) const
{
  return (_children.size() > (size_t)index) ? mforms::TreeNodeRef(_children[index]) : mforms::TreeNodeRef();
}

mforms::TreeNodeRef TreeNodeImpl::get_parent() const
{
  return _parent;
}

void TreeNodeImpl::clear_children(){}
void TreeNodeImpl::expand()
{
  _expanded = true;
}

void TreeNodeImpl::collapse()
{
  _expanded = false;
}

bool TreeNodeImpl::is_expanded()
{
  return _expanded;
}

void TreeNodeImpl::set_tag(const std::string &tag)
{
  _tag = tag;
}
std::string TreeNodeImpl::get_tag() const
{
  return _tag;
}

void TreeNodeImpl::set_data(mforms::TreeNodeData *data)
{
  pdata = data;
}

mforms::TreeNodeData *TreeNodeImpl::get_data() const
{
  return pdata;
}

TreeNodeImpl::TreeNodeImpl():
pdata(NULL),
_expanded(false)
{
  _parent = mforms::TreeNodeRef();
}
//------------------------------------------------------------------------------
//void TreeNodeImpl::init()
//{
//  ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();
//
//}
 
