/* 
 * Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _STUB_UTILITIES_H_
#define _STUB_UTILITIES_H_

#include "stub_mforms.h"

namespace mforms {
namespace stub {

class UtilitiesImpl
{
  static boost::function<void (std::string)> open_url_slot;

  static std::map<const std::string, std::string> passwords;

  static int __stdcall show_message(const std::string &title, const std::string &text,
                          const std::string &ok, const std::string &cancel,
                          const std::string &other);
  static int __stdcall show_error(const std::string &title, const std::string &text,
                        const std::string &ok, const std::string &cancel,
                        const std::string &other);
  static int __stdcall show_warning(const std::string &title, const std::string &text,
                        const std::string &ok, const std::string &cancel,
                        const std::string &other);
  static int __stdcall show_message_with_checkbox(const std::string &title, const std::string &text,
                        const std::string &ok, const std::string &cancel,
                        const std::string &other,
                        const std::string &checkbox_text, // empty text = default "Don't show this message again" text
                        bool &remember_checked);

  static void __stdcall show_wait_message(const std::string &title, const std::string &text);
  static bool __stdcall hide_wait_message();
  static bool __stdcall run_cancelable_wait_message(const std::string &title, const std::string &text,
                        const boost::function<void ()> &start_task, const boost::function<bool ()> &cancel_task);
  static void __stdcall stop_cancelable_wait_message();
    
  static void __stdcall set_clipboard_text(const std::string &text);
  static std::string __stdcall get_clipboard_text();

  static std::string __stdcall get_special_folder(mforms::FolderType type);


  static void __stdcall open_url(const std::string &url);
  static void __stdcall add_timeout(float interval, const boost::function<bool ()> &slot);

  static void __stdcall store_password(const std::string &service, const std::string &account, const std::string &password);
  static bool __stdcall find_password(const std::string &service, const std::string &account, std::string &password);
  static void __stdcall forget_password(const std::string &service, const std::string &account);
  static void* __stdcall perform_from_main_thread(const boost::function<void* ()>& slot, bool wait);

public:
  static void init();
  static void set_open_url_slot(const boost::function<void (std::string)> &slot);


};

};
};

#endif


    
