/* 
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

using namespace MySQL;
using namespace MySQL::Forms;

// Callback definitions.
MCallback::~MCallback()
{
};

//--------------------------------------------------------------------------------------------------

ObjectImpl::ObjectImpl(::mforms::Object *object)
{
  control= nullptr;
  dialog= nullptr;
  toolStripItem = nullptr;

  // Get a fixed pointer to this object.
  IntPtr ip = this->GetFixedId();

  // Store this pointer in the backend object as mapping from backend to wrapper.
  object->set_data((void*)(intptr_t) ip);

  Manager::get_instance()->instance_created();
}

//--------------------------------------------------------------------------------------------------

ObjectImpl::~ObjectImpl()
{
  mforms::Object *backend = get_backend_control<mforms::Object>(get_control());
  if (backend != NULL)
    backend->set_data(NULL);

  if (control != nullptr)
  {
    delete control->Tag;
    control->Tag = nullptr;
  }

  delete control;
  delete dialog;
  delete toolStripItem;

  ReleaseHandle();
  
  Manager::get_instance()->instance_destroyed();
}

//--------------------------------------------------------------------------------------------------
