/* 
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include "mforms/dockingpoint.h"

#include "wf_dockingpoint.h"

using namespace MySQL::Forms;


class MySQL::Forms::DockingPointDelegateProxy : public mforms::DockingPointDelegate
{
  gcroot<Object^> _represented_object;
  gcroot<DockingPointDelegateWrapper^> _wrapper;
public:
  DockingPointDelegateProxy(DockingPointDelegateWrapper^ owner, Object ^represented_object)
  {
    _wrapper = owner;
    _represented_object = represented_object;
  }

  virtual std::string get_type()
  {
    return NativeToCppString(_wrapper->get_type(_represented_object));
  }

  virtual void dock_view(mforms::AppView *view, const std::string &arg1, int arg2)
  {
    AppViewImpl^ native_view= nullptr;
    if (view != NULL)
      native_view= (AppViewImpl^) ObjectImpl::FromUnmanaged(view);
    if (native_view != nullptr)
      _wrapper->dock_view(_represented_object, native_view, CppStringToNative(arg1), arg2);
    else
      throw std::exception("invalid view object");
  }

  virtual bool select_view(mforms::AppView *view)
  {
    AppViewImpl^ native_view= nullptr;
    if (view != NULL)
      native_view= (AppViewImpl^) ObjectImpl::FromUnmanaged(view);
    if (native_view != nullptr)
      return _wrapper->select_view(_represented_object, native_view);
    else
      throw std::exception("invalid view object");
    return false;
  }

  virtual void undock_view(mforms::AppView *view)
  {
    AppViewImpl^ native_view= nullptr;
    if (view != NULL)
      native_view= (AppViewImpl^) ObjectImpl::FromUnmanaged(view);
    if (native_view != nullptr)
      _wrapper->undock_view(_represented_object, native_view);
    else
      throw std::exception("invalid view object");
  }

  virtual void set_view_title(mforms::AppView *view, const std::string &title)
  {
    AppViewImpl^ native_view= nullptr;
    if (view != NULL)
      native_view= (AppViewImpl^) ObjectImpl::FromUnmanaged(view);
    if (native_view != nullptr)
      _wrapper->set_view_title(_represented_object, native_view, CppStringToNative(title));
    else
      throw std::exception("invalid view object");
  }

  virtual void get_size(int *w, int *h)
  {
    _wrapper->get_size(_represented_object, *w, *h);
  }
};


DockingPointDelegateWrapper::DockingPointDelegateWrapper(Object ^represented_object)
{
  _proxy = new DockingPointDelegateProxy(this, represented_object);
}


DockingPointDelegateWrapper::~DockingPointDelegateWrapper()
{
  delete _proxy;
}

mforms::DockingPointDelegate* DockingPointDelegateWrapper::get_unmanaged_delegate()
{
  return _proxy;
}