/* 
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#pragma once

#pragma warning(disable: 4793) // 'vararg' causes native code generation
#pragma warning(disable: 4996) // 'std::_Uninitialized_copy0': Function call with parameters that may be unsafe
                               // A warning caused by the usage of boost in this context.

#define WIN32_LEAN_AND_MEAN 
#include <windows.h>
#include "WinCrypt.h"
#include <ShellAPI.h>
#include "commctrl.h"

#define _USE_MATH_DEFINES
#include <math.h>
#define INFINITY FLT_MAX

#include "gl/gl.h"

#include <cairo/cairo-Win32.h>

#include <sstream>
#include <boost/function.hpp>
#include <boost/signals2.hpp>


#include "base/string_utilities.h"
#include "base/file_utilities.h"
#include "base/log.h"
#include "base/geometry.h"
#include "base/trackable.h"

#include <mforms/view.h>
#include <mforms/form.h>
#include <mforms/button.h>
#include <mforms/checkbox.h>
#include <mforms/textentry.h>
#include <mforms/textbox.h>
#include <mforms/label.h>
#include <mforms/selector.h>
#include <mforms/listbox.h>
#include <mforms/tabview.h>
#include <mforms/box.h>
#include <mforms/panel.h>
#include <mforms/filechooser.h>
#include <mforms/radiobutton.h>
#include <mforms/imagebox.h>
#include <mforms/progressbar.h>
#include <mforms/table.h>
#include <mforms/scrollpanel.h>
#include <mforms/wizard.h>
#include <mforms/drawbox.h>
#include <mforms/tabswitcher.h>
#include <mforms/grttreeview.h>
#include <mforms/app.h>
#include <mforms/appview.h>
#include <mforms/utilities.h>
#include <mforms/uistyle.h>
#include <mforms/appview.h>
#include <mforms/sectionbox.h>
#include <mforms/widgets.h>
#include <mforms/menu.h>
#include <mforms/splitter.h>
#include <mforms/webbrowser.h>
#include <mforms/popup.h>
#include <mforms/code_editor.h>
#include <mforms/menubar.h>
#include <mforms/toolbar.h>
#include <mforms/task_sidebar.h>
#include <mforms/grid.h>
#include <mforms/hypertext.h>
#include <mforms/popover.h>
#include <mforms/fs_object_selector.h>
#include <mforms/simpleform.h>
#include <mforms/grid.h>
#include <mforms/treenodeview.h>
#include <mforms/find_panel.h>
#include <mforms/mforms.h>

#include "wf_app.h"
#include "wf_button.h"
#include "wf_form.h"
#include "wf_mforms.h"
#include "wf_checkbox.h"
#include "wf_textentry.h"
#include "wf_textbox.h"
#include "wf_imagebox.h"
#include "wf_label.h"
#include "wf_selector.h"
#include "wf_panel.h"
#include "wf_tabview.h"
#include "wf_box.h"
#include "wf_progressbar.h"
#include "wf_radiobutton.h"
#include "wf_table.h"
#include "wf_filechooser.h"
#include "wf_listbox.h"
#include "wf_wizard.h"
#include "wf_scrollpanel.h"
#include "wf_utilities.h"
#include "wf_grttreeview.h"
#include "wf_drawbox.h"
#include "wf_appview.h"
#include "wf_splitter.h"
#include "wf_webbrowser.h"
#include "wf_popup.h"
#include "wf_menu.h"
#include "wf_menubar.h"
#include "wf_toolbar.h"
#include "wf_code_editor.h"
#include "wf_hypertext.h"
#include "wf_popover.h"
#include "wf_grid.h"
#include "wf_treenodeview.h"
#include "wf_find_panel.h"

