/* 
 * Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include "base/log.h"
#include "mysql_sql_editor_be.h"

#include "mforms/code_editor.h"

using namespace bec;
using namespace grt;

DEFAULT_LOG_DOMAIN("MySQL editor")

//--------------------------------------------------------------------------------------------------

Mysql_sql_editor::Mysql_sql_editor(db_mgmt_RdbmsRef rdbms, GrtVersionRef version)
  : Sql_editor(rdbms, version)
{
  mforms::SyntaxHighlighterLanguage lang = mforms::LanguageMySQL;
  
  if (version.is_valid() && *version->majorNumber() == 5)
  {
    switch (*version->minorNumber())
    {
      case 0: lang = mforms::LanguageMySQL50; break;
      case 1: lang = mforms::LanguageMySQL51; break;
      case 5: lang = mforms::LanguageMySQL55; break;
      case 6: lang = mforms::LanguageMySQL56; break;
    }
  }
  get_editor_control()->set_language(lang);
  _editor_config = new mforms::CodeEditorConfig(lang);
}

//--------------------------------------------------------------------------------------------------

Mysql_sql_editor::~Mysql_sql_editor()
{
  delete _editor_config;
}

//--------------------------------------------------------------------------------------------------

bool Mysql_sql_editor::fill_auto_completion_keywords(std::vector<std::pair<int, std::string> > &entries,
  bool keywords, bool functions)
{
  log_debug2("Filling keywords auto completion list for MySQL.\n");

  if (_editor_config != NULL)
  {
    log_debug2("Adding keywords + function names\n");

    std::map<std::string, const char*> keyword_map = _editor_config->get_keywords();

    if (keywords)
    {
      // TODO: optionally keywords can be made uppercase (create a preference and convert here).
      std::vector<std::string> words = base::split_by_set(keyword_map["Major Keywords"], " \t\n");
      for (std::vector<std::string>::const_iterator iterator = words.begin(); iterator != words.end(); ++iterator)
        entries.push_back(std::pair<int, std::string>(AC_KEYWORD_IMAGE, *iterator));
      words = base::split_by_set(keyword_map["Procedure keywords"], " \t\n");
      for (std::vector<std::string>::const_iterator iterator = words.begin(); iterator != words.end(); ++iterator)
        entries.push_back(std::pair<int, std::string>(AC_KEYWORD_IMAGE, *iterator));
      words = base::split_by_set(keyword_map["User Keywords 1"], " \t\n");
      for (std::vector<std::string>::const_iterator iterator = words.begin(); iterator != words.end(); ++iterator)
        entries.push_back(std::pair<int, std::string>(AC_KEYWORD_IMAGE, *iterator));
    }
    if (functions)
    {
      std::vector<std::string> words = base::split_by_set(keyword_map["Functions"], " \t\n");
      for (std::vector<std::string>::const_iterator iterator = words.begin(); iterator != words.end(); ++iterator)
        entries.push_back(std::pair<int, std::string>(AC_FUNCTION_IMAGE, *iterator + "()"));
    }
  }

  return true;
}

//--------------------------------------------------------------------------------------------------
