
#include "model_panel.h"
#include "overview_panel.h"
#include "linux_utilities/gtk_helpers.h"
#include <gtkmm/alignment.h>
#include <gtkmm/notebook.h>
#include <gtk/gtkhpaned.h>
#include "mforms/../gtk/lf_toolbar.h"
#include "mforms/../gtk/lf_menubar.h"
#include "user_types_box.h"
#include "history_tree.h"
#include "documentation_box.h"

#define _(s) s

bool ModelPanel::on_close()
{ 
  _overview->on_close(); 
  return !_wb->get_wb()->has_unsaved_changes();
}


ModelPanel *ModelPanel::create(wb::WBContextUI *wb, wb::OverviewBE *overview)
{
  Glib::RefPtr<Gtk::Builder> xml= Gtk::Builder::create_from_file(wb->get_wb()->get_grt_manager()->get_data_file_path("model_view.glade"));

  ModelPanel *panel = 0;
  xml->get_widget_derived<ModelPanel>("top_vbox", panel);
  panel->post_construct(wb, overview, xml);
  
  return Gtk::manage(panel);
}


static void fix_size(Gtk::Paned *paned)
{
  int pos = paned->get_position();
  paned->set_position(paned->get_parent()->get_width() - paned->get_position());
}

ModelPanel::ModelPanel(GtkVBox *paned, Glib::RefPtr<Gtk::Builder> xml)
  : Gtk::VBox(paned), _wb(0)
{
}

void ModelPanel::post_construct(wb::WBContextUI *wb, wb::OverviewBE *overview, Glib::RefPtr<Gtk::Builder> xml)
{
  _wb= wb;
  {
    mforms::MenuBar *menubar = overview->get_menubar();
    if (menubar)
      pack_start(*mforms::gtk::widget_for_menubar(menubar), false, true);
    mforms::ToolBar *toolbar = overview->get_toolbar();
    if (toolbar)
      pack_start(*mforms::gtk::widget_for_toolbar(toolbar), false, true);
  }
  show_all();

  if (wb->get_wb()->get_wb_options().get_int("Sidebar:RightAligned", 0))
  {
    Gtk::Paned *p;
    xml->get_widget("model_pane", p);
    swap_panned_children(p, true);
    signal_realize().connect(sigc::bind(sigc::ptr_fun(fix_size), p));
  }

  _overview = Gtk::manage(new OverviewPanel(wb, overview));
  
  xml->get_widget("editor_tab", _editor_note);
  xml->get_widget("content", _editor_paned);
  
  xml->get_widget("model_sidebar", _sidebar);
  
  Gtk::Alignment *placeholder;
  
  xml->get_widget("overview_placeholder", placeholder);
  
  placeholder->add(*_overview);
  _overview->show();
  
  Gtk::Notebook *note;
  Gtk::Label *label;

  xml->get_widget("side_model_note0", note);
  _documentation_box= Gtk::manage(new DocumentationBox(wb));
  label = Gtk::manage(new Gtk::Label(_("<small>Description</small>")));
  note->append_page(*_documentation_box, *label);
  label->set_use_markup(true);

  xml->get_widget("side_model_note1", note);
  _usertypes_box= Gtk::manage(new UserTypesBox(wb));
  label = Gtk::manage(new Gtk::Label(_("<small>User Types</small>")));
  note->append_page(*_usertypes_box, *label);
  label->set_use_markup(true);

  _history_tree= Gtk::manage(new HistoryTree(wb));
  label = Gtk::manage(new Gtk::Label(_("<small>History</small>")));
  note->append_page(*_history_tree, *label);
  label->set_use_markup(true);

}


void ModelPanel::selection_changed()
{
  _documentation_box->update_for_form(_overview->get_be());
}


bec::UIForm *ModelPanel::get_form() const
{
  return (bec::UIForm*)_overview->get_be();
}


void ModelPanel::toggle_sidebar()
{
  if (_sidebar->is_visible())
    _sidebar->hide();
  else
    _sidebar->show();
}


void ModelPanel::find_text(const std::string &text)
{
  _last_found_node = _overview->get_be()->search_child_item_node_matching(bec::NodeId()
                                                                          , _last_found_node
                                                                          ,text
                                                                          );

  if (_last_found_node.is_valid())
  {
    get_overview()->select_node(_last_found_node);
  }
}
