#include "wb_config.h"
#include "linux_utilities/plugin_editor_base.h"
#include "../backend/mysql_routine_editor.h"
#include "grtdb/db_object_helpers.h"
#include "treemodel_wrapper.h"
#include "mysql_editor_priv_page.h"
#include "gtk/mforms_gtk.h"

//==============================================================================
//
//==============================================================================
class DbMySQLRoutineEditor : public PluginEditorBase
{
  MySQLRoutineEditorBE              *_be;
  DbMySQLEditorPrivPage             *_privs_page;
  
  virtual bec::BaseEditor *get_be();
  
  virtual bool can_close() { return _be->can_close(); }
 public:
  DbMySQLRoutineEditor(grt::Module *m, bec::GRTManager *grtm, const grt::BaseListRef &args);
  
  virtual ~DbMySQLRoutineEditor();
  virtual void do_refresh_form_data();

  virtual bool switch_edited_object(bec::GRTManager *grtm, const grt::BaseListRef &args);
};

DbMySQLRoutineEditor::DbMySQLRoutineEditor(grt::Module *m, bec::GRTManager *grtm, const grt::BaseListRef &args)
    : PluginEditorBase(m, grtm, args, "modules/data/editor_routine.glade")
    , _be(new MySQLRoutineEditorBE(grtm, db_mysql_RoutineRef::cast_from(args[0]), get_rdbms_for_db_object(args[0])))
{
  xml()->get_widget("mysql_routine_editor_notebook", _editor_notebook);

  Gtk::Image *image;
  xml()->get_widget("routine_editor_image", image);
  image->set(ImageCache::get_instance()->image_from_filename("db.Routine.editor.48x48.png", false));

  _be->set_refresh_ui_slot(sigc::mem_fun(this, &DbMySQLRoutineEditor::refresh_form_data));
  
  _editor_notebook->reparent(*this);
  _editor_notebook->show();

  Gtk::VBox *ddl_win;
  xml()->get_widget("routine_ddl", ddl_win);
  embed_code_editor(_be->get_sql_editor()->get_editor_control(), ddl_win);
  _be->load_routine_sql();

  if (!is_editing_live_object())
  {
    _privs_page     = new DbMySQLEditorPrivPage(_be);
    _editor_notebook->append_page(_privs_page->page(), "Privileges");
  }
  else
  {
    _privs_page= NULL;
  }

  refresh_form_data();
  
  show_all();
}

//------------------------------------------------------------------------------
DbMySQLRoutineEditor::~DbMySQLRoutineEditor()
{
  delete _privs_page;
  delete _be;
}

//------------------------------------------------------------------------------
bool DbMySQLRoutineEditor::switch_edited_object(bec::GRTManager *grtm, const grt::BaseListRef &args)
{
  Gtk::VBox *ddl_win;
  xml()->get_widget("routine_ddl", ddl_win);
 
  delete _be;

  _be = new MySQLRoutineEditorBE(grtm, db_mysql_RoutineRef::cast_from(args[0]), get_rdbms_for_db_object(args[0]));

  embed_code_editor(_be->get_sql_editor()->get_editor_control(), ddl_win);
  _be->load_routine_sql();

  _be->set_refresh_ui_slot(sigc::mem_fun(this, &DbMySQLRoutineEditor::refresh_form_data));

  if (!is_editing_live_object())
    _privs_page->switch_be(_be);

  refresh_form_data();

  return true;
}

//------------------------------------------------------------------------------

bec::BaseEditor *DbMySQLRoutineEditor::get_be()
{
  return _be;
}

//------------------------------------------------------------------------------
void DbMySQLRoutineEditor::do_refresh_form_data()
{
  Gtk::Entry* entry(0);
  xml()->get_widget("routine_name", entry);
  if (entry->get_text() != _be->get_name())
  {
    entry->set_text(_be->get_name());
    _signal_title_changed.emit(_be->get_title());
  }

  _be->load_routine_sql();

  if (!is_editing_live_object())
    _privs_page->refresh();
}

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
extern "C" 
{
  GUIPluginBase *createDbMysqlRoutineEditor(grt::Module *m, bec::GRTManager *grtm, const grt::BaseListRef &args)
  {
    return Gtk::manage(new DbMySQLRoutineEditor(m, grtm, args));
  }
};

