//!
//! \addtogroup linuxui Linux UI
//! @{
//! 

#ifndef _MODEL_VIEW_PANEL_H_
#define _MODEL_VIEW_PANEL_H_

#include "linux_utilities/form_view_base.h"

#include <gtkmm/paned.h>
#include <gtkmm/box.h>
#include <gtkmm/notebook.h>
#include <gtkmm/builder.h>
#include "model/wb_model_diagram_form.h"
#include "gtk/mdc_gtk_canvas_view.h"
#include "gtk/mdc_gtk_canvas_scroller.h"
#include "mdc_canvas_view_x11.h"

namespace Gtk
{
  class Entry;
};

namespace wb
{
  class WBContextUI;
};

class CatalogTree;
class PropertiesTree;
class DocumentationBox;
class NavigatorBox;
class InfoBox;


class ModelDiagramPanel : public Gtk::HPaned, public FormViewBase
{
  class InlineEditor : public wb::InlineEditContext
  {
    ModelDiagramPanel *_owner;
    Gtk::Entry *_edit_field;
    bool _editing;
    
    virtual void begin_editing(int x, int y, int width, int height, const std::string &text);
    virtual void end_editing();

    virtual void set_font_size(float size);
    virtual void set_multiline(bool flag);

  public:
    InlineEditor(ModelDiagramPanel *owner);
  };
  
  friend class InlineEditor;
 
  Gtk::VBox  _top_box;

  Gtk::VBox *_tools_toolbar;
  
  Gtk::Box *_vbox;
  Gtk::HBox *_diagram_hbox;

  wb::WBContextUI *_wb;
  wb::ModelDiagramForm *_be;
  mdc::GtkCanvasScroller _scroller;
  mdc::GtkCanvas *_canvas;
  Gdk::Cursor *_cursor;
  InlineEditor _inline_editor;
  Gtk::Paned *_editor_paned;
  Gtk::Widget *_sidebar;

  NavigatorBox                *_navigator_box;
  CatalogTree                 *_catalog_tree;
  mforms::TreeNodeView        *_usertypes_list;
  mforms::TreeNodeView        *_history_list;
  DocumentationBox            *_documentation_box;
  PropertiesTree              *_properties_tree;
  Glib::RefPtr<Gtk::Builder>   _xml;

  bool drag_drop(const Glib::RefPtr<Gdk::DragContext> &context, int x, int y, guint time);

  void drag_data_received(const Glib::RefPtr<Gdk::DragContext> &context, int x, int y,
                          const Gtk::SelectionData &selection_data,
                          guint, guint time);

  void view_realized();

  void post_construct(wb::WBContextUI *wb, Glib::RefPtr<Gtk::Builder> xml);

public:
  static ModelDiagramPanel *create(wb::WBContextUI *wb);

  ModelDiagramPanel(GtkHPaned *paned, Glib::RefPtr<Gtk::Builder> xml);
  ~ModelDiagramPanel();

  void init(const std::string &view_id);
  virtual bec::UIForm *get_form() const { return _be; }
  virtual Gtk::Widget *get_panel() { return &_top_box; }
  virtual bool on_close();
  virtual void toggle_sidebar();
  
  wb::ModelDiagramForm *get_diagram_form() const { return _be; }
    
  mdc::CanvasView *get_canvas() const { return _canvas->get_canvas(); }
  
  void update_tool_cursor();

  void setup_navigator();
  void refresh_catalog(bool hard);
  void refresh_zoom();
  
  void selection_changed();

  virtual void find_text(const std::string &text);

  virtual void reset_layout() { _editor_paned->set_position(_editor_paned->get_height()-300); }
};


#endif /* _MODEL_VIEW_PANEL_H_ */

//!
//! @}
//!
