using System;
using System.Drawing;
using System.Windows.Forms;

using MySQL.Utilities;

namespace MySQL.Controls
{
  public class DrawablePanel : Panel
  {
    private bool customBackground = false;

    public DrawablePanel()
    {
      DoubleBuffered = true;
    }

    public bool CustomBackground
    {
      get { return customBackground; }
      set { customBackground = value; }
    }

    public event EventHandler<PaintEventArgs> PaintBackground;
    protected override void OnPaintBackground(PaintEventArgs e)
    {
      if (!customBackground)
      {
        // With Aero enabled a panel behaves strange when placed on a transparent window.
        if (ControlUtilities.IsCompositionEnabled())
          using (SolidBrush brush = new SolidBrush(BackColor))
            e.Graphics.FillRectangle(brush, ClientRectangle);
        else
          base.OnPaintBackground(e);
      }
      
      // Since there is no event handler triggered in the ancestor we do it here.

      if (PaintBackground != null)
        PaintBackground(this, e);
    }
  }
}
