/* 
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#include "stdafx.h"

#include "mforms/mforms.h"

using namespace mforms;
  
GRTTreeView::GRTTreeView(TreeOptions options)
  : _context_menu(0)
{
  _grttreeview_impl= &ControlFactory::get_instance()->_grttreeview_impl;

  _grttreeview_impl->create(this, options);
}

void GRTTreeView::set_context_menu(Menu *menu)
{
  _context_menu = menu;
}

void GRTTreeView::set_model(bec::TreeModel *model)
{
  _grttreeview_impl->set_model(this, model);
}


int GRTTreeView::add_column(GRTTreeColumnType type, int model_column, const std::string &name)
{
  return _grttreeview_impl->add_column(this, type, model_column, name);
}


int GRTTreeView::add_column_editable(GRTTreeColumnType type, int model_column, const std::string &name)
{
  return _grttreeview_impl->add_column_editable(this, type, model_column, name);
}


void GRTTreeView::refresh(const bec::NodeId &node)
{
  _grttreeview_impl->refresh(this, node);
}


void GRTTreeView::row_count_changed(const bec::NodeId &parent, int old_count)
{
  _grttreeview_impl->row_count_changed(this, parent, old_count);
}


void GRTTreeView::set_column_width(int model_column, int width)
{
  _grttreeview_impl->set_column_width(this, model_column, width);
}


void GRTTreeView::row_activate_callback(const bec::NodeId &node, int column)
{
  _activate_signal(node, column);
}


void GRTTreeView::changed()
{
  _changed_signal();
}


void GRTTreeView::set_allow_multi_selection(bool flag)
{
  _grttreeview_impl->set_allow_multi_selection(this, flag);
}

//--------------------------------------------------------------------------------------------------

bool GRTTreeView::get_selected_node(bec::NodeId &node)
{
  return _grttreeview_impl->get_selected_node(this, node);
}

//--------------------------------------------------------------------------------------------------

int GRTTreeView::get_selection(std::vector<bec::NodeId> &nodes)
{
  return _grttreeview_impl->get_selection(this, nodes);
}

//--------------------------------------------------------------------------------------------------

void GRTTreeView::set_expanded(const bec::NodeId& node, bool expanded)
{
  _grttreeview_impl->set_expanded(this, node, expanded);
}

//--------------------------------------------------------------------------------------------------

void GRTTreeView::enable_asynch_loading(bool enabled)
{
  if (_grttreeview_impl->enable_asynch_loading)
    _grttreeview_impl->enable_asynch_loading(this, enabled);
}
//--------------------------------------------------------------------------------------------------
