/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _LF_TEXTENTRY_H_
#define _LF_TEXTENTRY_H_

#include <mforms/mforms.h>

#include "lf_view.h"


namespace mforms {
namespace gtk {

class TextEntryImpl : public ViewImpl
{
  Gtk::Entry    *_entry;
  std::string _placeholder;
  Gdk::Color _text_color;
  TextEntryType _type;
  bool _has_real_text;
  bool _changing_text;
  virtual Gtk::Widget *get_outer() const { return _entry; }
  
  TextEntryImpl(::mforms::TextEntry *self, TextEntryType type);
  static bool create(::mforms::TextEntry *self, TextEntryType type);
  static void set_text(::mforms::TextEntry *self, const std::string &text);
  static void set_placeholder_text(::mforms::TextEntry *self, const std::string &text);
  static void set_max_length(::mforms::TextEntry *self, int len);
  static std::string get_text(::mforms::TextEntry *self);
  static void set_read_only(::mforms::TextEntry *self, bool flag);
  void activated(mforms::TextEntry *self);
  bool key_press(GdkEventKey *event, mforms::TextEntry *self);
 
#if GTK_VERSION_GT(2, 16)
  void icon_pressed(Gtk::EntryIconPosition pos, const GdkEventButton *ev);
#endif

  void set_placeholder_text(const std::string &text);
  void set_text(const std::string &text);
  void focus_in(GdkEventFocus*);
  void focus_out(GdkEventFocus*);
  void changed(mforms::TextEntry *);

public:
  static void init();
};

  };
};

#endif
