/* 
 * Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

namespace MySQL {
namespace Grt {

using namespace MySQL::Grt;

VarGridModelWrapper::VarGridModelWrapper(Ref ref)
  : GridModel((&ref).get()), //! temporary solution, update base classes to accept Ref in constructor
  _ref(ref)
{
}


VarGridModelWrapper::VarGridModelWrapper(IntPtr nref_ptr)
  : GridModel(((::VarGridModel::Ref*)(void*)(nref_ptr))->get()), //! temporary solution, update base classes to accept Ref in constructor
  _ref(gcnew ManagedRef<::VarGridModel>(nref_ptr))
{
}


VarGridModelWrapper::~VarGridModelWrapper()
{
  if (!(void*)~_ref)
    return;
  delete _refresh_ui_cb;
  delete _ref;
}


void VarGridModelWrapper::refresh_ui_cb(Refresh_ui_cb::ManagedDelegate ^cb)
{
  if (cb != nullptr)
  {
    _refresh_ui_cb= gcnew Refresh_ui_cb(cb);
    _ref->refresh_ui_cb= _refresh_ui_cb->get_slot();
  }
  else
  {
    _refresh_ui_cb= nullptr;
    
    if (!_ref)
      _ref->refresh_ui_cb= boost::function<int ()>();
  }
}


};  // namespace Grt
};  // namespace MySQL
