#ifndef _SQLITE_VARIANT_HPP_
#define _SQLITE_VARIANT_HPP_

#include <boost/variant.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/cstdint.hpp>
#include <vector>
#include <string>
#include <sstream>

namespace sqlite{

class Unknown {};
class Null {};
typedef std::vector<unsigned char> Blob;
typedef boost::shared_ptr<Blob> BlobRef;
typedef boost::variant<int, boost::int64_t, long double, std::string, Unknown, Null, BlobRef> Variant;

}

#endif /* _SQLITE_VARIANT_HPP_*/
