//
//  WBDiagramSizeController.m
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 21/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import "WBDiagramSizeController.h"
#import "MCanvasViewer.h"
#import "NSString_extras.h"

#include "workbench/wb_context_ui.h"
#include "model/wb_diagram_options.h"

@implementation WBDiagramSizeController

- (void)dealloc
{
  delete _be;
  [super dealloc];
}


static void update_size_entries(WBDiagramSizeController *self)
{
  [self->widthField setIntegerValue: self->_be->get_xpages()];
  [self->heightField setIntegerValue: self->_be->get_ypages()];
}


- (id)initWithWBContext:(wb::WBContextUI*)wbui
{
  self= [super init];
  if (self)
  {    
    [NSBundle loadNibNamed:@"DiagramOptions" owner:self];

    [canvas lockFocus];
    [canvas setupQuartz];
    [canvas unlockFocus];
    
    _be= wbui->create_diagram_options_be([canvas canvas]);
    _be->update_size();
    _be->signal_changed()->connect(boost::bind(update_size_entries, self));
    
    [nameField setStringValue: [NSString stringWithCPPString:_be->get_name()]];
    
    update_size_entries(self);
  }
  return self;
}


- (IBAction)okClicked:(id)sender
{
  _be->set_name([[nameField stringValue] UTF8String]);
  
  _be->commit();
  [panel performClose:nil];
}


- (void)windowWillClose:(NSNotification *)notification
{
  [NSApp stopModal];
}


- (void)controlTextDidEndEditing:(NSNotification *)aNotification
{
  if ([aNotification object] == widthField)
    _be->set_xpages([widthField integerValue]);
  else if ([aNotification object] == heightField)
    _be->set_ypages([heightField integerValue]);
}  


- (void)showModal
{
  [panel makeKeyAndOrderFront:nil];
  
  [NSApp runModalForWindow:panel];
}

@end
