/* 
 * Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_FILECHOOSER_H_
#define _WF_FILECHOOSER_H_

using namespace System;
using namespace Windows::Forms;

namespace MySQL {
  namespace Forms {

    public ref class FileChooserImpl : public ViewImpl
    {
      FileChooserImpl(mforms::FileChooser* form, mforms::Form* owner);
      ~FileChooserImpl();

      static bool create(mforms::FileChooser* self, mforms::Form* owner, mforms::FileChooserType type,
        bool show_hidden);
      static void set_title(mforms::FileChooser* self, const std::string& title);
      static bool run_modal(mforms::FileChooser* self);
      static void set_directory(mforms::FileChooser* self, const std::string& path);
      static void set_path(mforms::FileChooser* self, const std::string& path);
      static std::string get_directory(mforms::FileChooser* self);
      static std::string get_path(mforms::FileChooser* self);
      static void set_extensions(mforms::FileChooser* self, const std::string& extensions, 
        const std::string& default_extension);
      static void add_selector_option(mforms::FileChooser* self, const std::string&,
        const std::string&, const mforms::FileChooser::StringPairVector&);
      static std::string get_selector_option_value(mforms::FileChooser* self, const std::string&);
    public:
      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK4(bool, mforms::FileChooser*, ::mforms::Form *, ::mforms::FileChooserType, bool, mgr, f->_filechooser_impl, FileChooserImpl, create);
        DEF_CALLBACK2(void, mforms::FileChooser*, const std::string&, mgr, f->_filechooser_impl, FileChooserImpl, set_title);
        DEF_CALLBACK1(bool, mforms::FileChooser*, mgr, f->_filechooser_impl, FileChooserImpl, run_modal);
        DEF_CALLBACK3(void, mforms::FileChooser*, const std::string&, const std::string&, mgr, f->_filechooser_impl, FileChooserImpl, set_extensions);
        DEF_CALLBACK2(void, mforms::FileChooser*, const std::string&, mgr, f->_filechooser_impl, FileChooserImpl, set_directory);
        DEF_CALLBACK1(std::string, mforms::FileChooser*, mgr, f->_filechooser_impl, FileChooserImpl, get_directory);
        DEF_CALLBACK1(std::string, mforms::FileChooser*, mgr, f->_filechooser_impl, FileChooserImpl, get_path);
        DEF_CALLBACK2(void, mforms::FileChooser*, const std::string &, mgr, f->_filechooser_impl, FileChooserImpl, set_path);
        DEF_CALLBACK4(void, mforms::FileChooser*, const std::string&, const std::string&, const mforms::FileChooser::StringPairVector&, mgr, f->_filechooser_impl, FileChooserImpl, add_selector_option);
        DEF_CALLBACK2(std::string, mforms::FileChooser*, const std::string&, mgr, f->_filechooser_impl, FileChooserImpl, get_selector_option_value);
      }
    };

  };
};

#endif
