/* 
 * Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_HYPERTEXT_H_
#define _WF_HYPERTEXT_H_

namespace MySQL {
  namespace Forms {

    /**
     * Windows wrapper class for the mforms hypertext control.
     */
    public ref class HyperTextImpl : public ViewImpl
    {
    protected:
      static bool create(mforms::HyperText *self);
      static void set_markup_text(mforms::HyperText *self, const std::string &text);

      static void LinkClicked(Object^ sender, UrlClickEventArgs^ args);
    public:
      HyperTextImpl(mforms::HyperText *self);

      void SetMarkupText(const std::string &text);

      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK1(bool, mforms::HyperText*, mgr, f->_hypertext_impl, HyperTextImpl, create);
        DEF_CALLBACK2(void, mforms::HyperText*, const std::string&, mgr, f->_hypertext_impl, HyperTextImpl, set_markup_text);
      }
    };

  };
};


#endif // _WF_HYPERTEXT_H_
