#include "stdafx.h"



#include "grtpp.h"
#include "interfaces/plugin.h"

#include "grts/structs.db.mgmt.h"


#define MODULE_VERSION "1.0.0"


#ifdef _WIN32
# define FRONTEND_LIBNAME(obj, windows_dll, linux_so, osx_dylib)\
  obj->moduleName(windows_dll)
#elif defined(__APPLE__)
# define FRONTEND_LIBNAME(obj, windows_dll, linux_so, osx_dylib)\
  obj->moduleName(osx_dylib)
#else
# define FRONTEND_LIBNAME(obj, windows_dll, linux_so, osx_dylib)\
  obj->moduleName(linux_so)
#endif



static grt::ListRef<app_Plugin> get_mysql_plugins_info(grt::GRT *grt);


class MySQLEditorsModuleImpl : public grt::ModuleImplBase, public PluginInterfaceImpl
{
public:
  MySQLEditorsModuleImpl(grt::CPPModuleLoader *ldr)
  : grt::ModuleImplBase(ldr)
  {
  }

  DEFINE_INIT_MODULE(MODULE_VERSION, "MySQL AB", grt::ModuleImplBase,
    DECLARE_MODULE_FUNCTION(MySQLEditorsModuleImpl::getPluginInfo), NULL);

  virtual grt::ListRef<app_Plugin> getPluginInfo()
  {
    return get_mysql_plugins_info(get_grt());
  }
};



static void set_object_argument(app_PluginRef &plugin, const std::string &struct_name)
{
  app_PluginObjectInputRef pdef(plugin.get_grt());

  pdef->objectStructName(struct_name);
  pdef->owner(plugin);

  plugin->inputValues().insert(pdef);
}



static grt::ListRef<app_Plugin> get_mysql_plugins_info(grt::GRT *grt)
{
  grt::ListRef<app_Plugin> editors(grt);

  app_PluginRef schema_editor(grt);
  app_PluginRef table_editor(grt);
  app_PluginRef view_editor(grt);
  app_PluginRef routine_group_editor(grt);
  app_PluginRef routine_editor(grt);
  app_PluginRef user_editor(grt);
  app_PluginRef role_editor(grt);
  app_PluginRef relationship_editor(grt);
  
  FRONTEND_LIBNAME(schema_editor,
                   ".\\db.mysql.editors.wbp.fe.dll",
                   "db.mysql.editors.wbp.so",
                   "db.mysql.editors.mwbplugin");
  schema_editor->pluginType("gui");
  schema_editor->moduleFunctionName("DbMysqlSchemaEditor");
  set_object_argument(schema_editor, "db.mysql.Schema");
  schema_editor->rating(10);
  schema_editor->caption("Edit Schema");
  schema_editor->name("db.mysql.plugin.edit.schema");
  schema_editor->groups().insert("catalog/Editors");
  editors.insert(schema_editor);

  FRONTEND_LIBNAME(table_editor,
                   ".\\db.mysql.editors.wbp.fe.dll",
                   "db.mysql.editors.wbp.so",
                   "db.mysql.editors.mwbplugin");
  table_editor->pluginType("gui");
  table_editor->moduleFunctionName("DbMysqlTableEditor");
  set_object_argument(table_editor, "db.mysql.Table");
  table_editor->caption("Edit Table");
  table_editor->rating(10);
  table_editor->name("db.mysql.plugin.edit.table");
  table_editor->groups().insert("catalog/Editors");
  editors.insert(table_editor);


  FRONTEND_LIBNAME(view_editor, 
                   ".\\db.mysql.editors.wbp.fe.dll",
                   "db.mysql.editors.wbp.so",
                   "db.mysql.editors.mwbplugin");
  view_editor->pluginType("gui");
  view_editor->moduleFunctionName("DbMysqlViewEditor");
  set_object_argument(view_editor, "db.mysql.View");
  view_editor->caption("Edit View");
  view_editor->rating(10);
  view_editor->name("db.mysql.plugin.edit.view");
  view_editor->groups().insert("catalog/Editors");
  editors.insert(view_editor);

  FRONTEND_LIBNAME(routine_group_editor, 
                   ".\\db.mysql.editors.wbp.fe.dll",
                   "db.mysql.editors.wbp.so",
                   "db.mysql.editors.mwbplugin");
  routine_group_editor->pluginType("gui");
  routine_group_editor->moduleFunctionName("DbMysqlRoutineGroupEditor");
  set_object_argument(routine_group_editor, "db.mysql.RoutineGroup");
  routine_group_editor->caption("Edit Routine Group");
  routine_group_editor->rating(10);
  routine_group_editor->name("db.mysql.plugin.edit.routineGroup");
  routine_group_editor->groups().insert("catalog/Editors");
  editors.insert(routine_group_editor);

  FRONTEND_LIBNAME(routine_editor, 
                   ".\\db.mysql.editors.wbp.fe.dll",
                   "db.mysql.editors.wbp.so",
                   "db.mysql.editors.mwbplugin");
  routine_editor->pluginType("gui");
  routine_editor->moduleFunctionName("DbMysqlRoutineEditor");
  set_object_argument(routine_editor, "db.mysql.Routine");
  routine_editor->caption("Edit Routine");
  routine_editor->rating(10);
  routine_editor->name("db.mysql.plugin.edit.routine");
  routine_editor->groups().insert("catalog/Editors");
  editors.insert(routine_editor);


  // generic
  FRONTEND_LIBNAME(user_editor, 
                   ".\\db.mysql.editors.wbp.fe.dll",
                   "db.mysql.editors.wbp.so",
                   "db.mysql.editors.mwbplugin");
  user_editor->pluginType("gui");
  user_editor->moduleFunctionName("DbMysqlUserEditor");
  set_object_argument(user_editor, "db.User");
  user_editor->caption("Edit User");
  user_editor->rating(10);
  user_editor->name("db.mysql.plugin.edit.user");
  user_editor->groups().insert("catalog/Editors");
  editors.insert(user_editor);

  FRONTEND_LIBNAME(role_editor, 
                   ".\\db.mysql.editors.wbp.fe.dll",
                   "db.mysql.editors.wbp.so",
                   "db.mysql.editors.mwbplugin");
  role_editor->pluginType("gui");
  role_editor->moduleFunctionName("DbMysqlRoleEditor");
  set_object_argument(role_editor, "db.Role");
  role_editor->caption("Edit Role");
  role_editor->rating(10);
  role_editor->name("db.mysql.plugin.edit.role");
  role_editor->groups().insert("catalog/Editors");
  editors.insert(role_editor);

  FRONTEND_LIBNAME(relationship_editor, 
                   ".\\db.mysql.editors.wbp.fe.dll",
                   "db.mysql.editors.wbp.so",
                   "db.mysql.editors.mwbplugin");
  relationship_editor->pluginType("gui");
  relationship_editor->moduleFunctionName("DbMysqlRelationshipEditor");
  set_object_argument(relationship_editor, "workbench.physical.Connection");
  relationship_editor->caption("Edit Relationship");
  relationship_editor->rating(10);
  relationship_editor->name("db.mysql.plugin.edit.relationship");
  relationship_editor->groups().insert("catalog/Editors");
  editors.insert(relationship_editor);

  return editors;
}


GRT_MODULE_ENTRY_POINT(MySQLEditorsModuleImpl);
