#ifndef _WB_COMPONENT_H_
#define _WB_COMPONENT_H_

#include "workbench/wb_context.h"

namespace wb {

  class ModelDiagramForm;

  class WBComponent : public sigc::trackable
  {
  public:
    WBComponent(WBContext *context);
    virtual ~WBComponent() {};
    
    inline WBContext *get_wb() { return _wb; }
    inline grt::GRT *get_grt() { return _wb->get_grt_manager()->get_grt(); }
    inline bec::GRTManager *get_grt_manager() { return _wb->get_grt_manager(); }

    virtual std::string get_name()= 0;
    virtual std::string get_diagram_class_name() { return ""; }

    virtual void setup_context_grt(grt::GRT *grt, WBOptions *options) {}
    virtual void load_app_options(bool update) {}
    virtual void save_app_options() {}

    virtual void close_document() {}
    virtual void reset_document() {}
    virtual void document_loaded() {}
    virtual void block_model_notifications() {}
    virtual void unblock_model_notifications() {}

    virtual bool handles_figure(const model_ObjectRef &figure)= 0;
    virtual GrtObjectRef get_object_for_figure(const model_ObjectRef &figure) { return GrtObjectRef(); }
    virtual model_ObjectRef clone_object(const model_ObjectRef &object, const model_LayerRef &destlayer, grt::CopyContext &copy_context, bool copy_only) { return model_ObjectRef(); }

    virtual bool can_paste_non_model_object(const grt::ObjectRef &object) { return false; }
    virtual void paste_non_model_object(ModelDiagramForm *view, const grt::ObjectRef &object) { throw std::logic_error("not implemented"); }

    // toolbar/menubar handling
    virtual grt::ListRef<bec::MenuItem> get_menu_items(const std::string &menu) { return grt::ListRef<bec::MenuItem>(); }
    virtual grt::ListRef<app_ToolbarItem> get_toolbar_items(const std::string &toolbar) { return grt::ListRef<app_ToolbarItem>(); }
    virtual grt::ListRef<app_ShortcutItem> get_shortcut_items() { return grt::ListRef<app_ShortcutItem>(); }

    virtual std::vector<std::string> get_command_dropdown_items(const std::string &option) { return std::vector<std::string>(); }

    virtual std::string get_command_option_value(const std::string &option);
    virtual void set_command_option_value(const std::string &option, const std::string &item);

    virtual std::string get_object_tooltip(const model_ObjectRef &object, mdc::CanvasItem *item) { return ""; }

    // tool handling
    virtual void setup_canvas_tool(ModelDiagramForm *view, const std::string &tool)= 0;

    virtual bool delete_model_object(const model_ObjectRef &object, std::map<std::string,bool> &options)= 0;

    // drag&drop
    virtual std::vector<std::string> get_accepted_drop_types() const { return std::vector<std::string>(); }
    virtual bool accepts_drop(ModelDiagramForm *view, int x, int y, const std::string &type, const std::list<GrtObjectRef> &objects) { return false; }
    virtual bool accepts_drop(ModelDiagramForm *view, int x, int y, const std::string &type, const std::string &text) { return false; }

    virtual bool perform_drop(ModelDiagramForm *view, int x, int y, const std::string &type, const std::list<GrtObjectRef> &objects) { return false; }
    virtual bool perform_drop(ModelDiagramForm *view, int x, int y, const std::string &type, const std::string &text) { return false; }

  protected:
    grt::ValueRef place_object(ModelDiagramForm *view, const mdc::Point &pos,
                      const std::string &object_struct,
                      const grt::DictRef &args= grt::DictRef());
    grt::ValueRef place_object_grt(grt::GRT *grt, ModelDiagramForm *view, 
                                       const mdc::Point &pos, const std::string &object_struct,
                                       const grt::DictRef &args);


  public:
    virtual void activate_canvas_object(const model_ObjectRef &figure, bool newwindow)= 0;

  protected:
    WBContext *_wb;
  };

};

#endif
