#ifndef _DB_SQL_EDITOR_HISTORY_BE_H_
#define _DB_SQL_EDITOR_HISTORY_BE_H_


#include "workbench/wb_backend_public_interface.h"
#include "sqlide/var_grid_model_be.h"
#include <boost/shared_ptr.hpp>


class MYSQLWBBACKEND_PUBLIC_FUNC DbSqlEditorHistory
{
public:
  typedef boost::shared_ptr<DbSqlEditorHistory> Ref;
  static Ref create(bec::GRTManager *grtm) { return Ref(new DbSqlEditorHistory(grtm)); }
  virtual ~DbSqlEditorHistory() {}
protected:
  DbSqlEditorHistory(bec::GRTManager *grtm);
  bec::GRTManager *_grtm;

public:
  void reset();
  void add_entry(const std::list<std::string> &statements);
  int current_entry() { return _current_entry_index; }
  void current_entry(int index);
  std::string restore_sql_from_history(int entry_index, std::list<int> &detail_indexes);
protected:
  int _current_entry_index;

public:
  class EntriesModel;
  class DetailsModel;

public:
  class DetailsModel : public VarGridModel
  {
  public:
    typedef boost::shared_ptr<DetailsModel> Ref;
    static Ref create(bec::GRTManager *grtm) { return Ref(new DetailsModel(grtm)); }
  protected:
    DetailsModel(bec::GRTManager *grtm) : VarGridModel(grtm) { reset(); }

  public:
    virtual void reset();
    void add_entries(const std::list<std::string> &statements);
    void load_from(Ref details_model);
  };

public:
  class EntriesModel : public VarGridModel
  {
  public:
    typedef boost::shared_ptr<EntriesModel> Ref;
    static Ref create(bec::GRTManager *grtm) { return Ref(new EntriesModel(grtm)); }
  protected:
    EntriesModel(bec::GRTManager *grtm) : VarGridModel(grtm) { reset(); }

  public:
    virtual void reset();
    void add_entry(const std::list<std::string> &statements);

  public:
    DetailsModel::Ref details_model(int index) { return _details_models.at(index); }
  protected:
    std::vector<DetailsModel::Ref> _details_models;
  };

public:
  EntriesModel::Ref entries_model() { return _entries_model; }
  DetailsModel::Ref details_model() { return _details_model; }
protected:
  EntriesModel::Ref _entries_model;
  DetailsModel::Ref _details_model;
};


#endif /* _DB_SQL_EDITOR_HISTORY_BE_H_ */
