/*
 *  wb_context_sqlide.h
 *  MySQLWorkbench
 *
 *  Created by Alfredo Kojima on 29/Apr/09.
 *  Copyright 2009 Sun Microsystems Inc. All rights reserved.
 *
 */

#ifndef _WBCONTEXT_SQLIDE_H_
#define _WBCONTEXT_SQLIDE_H_

#include "workbench/wb_backend_public_interface.h"
#include "grt/grt_manager.h"
#include "grts/structs.db.mgmt.h"
#include "grts/structs.app.h"
#include "dialogs/search_replace.h"

class Db_sql_editor;

// Central point of management for SQLIDE (sql editor)
namespace wb 
{
  class WBContextUI;
  
  class MYSQLWBBACKEND_PUBLIC_FUNC WBContextSQLIDE
  {
    WBContextUI *_wbui;

  public:
    WBContextSQLIDE(WBContextUI *wbui);
    ~WBContextSQLIDE();
    void init();
    
    Db_sql_editor* create_connected_editor(const db_mgmt_ConnectionRef &conn);

    grt::ListRef<app_ToolbarItem> get_toolbar_items(const std::string &name);

    WBContextUI *get_wbui() { return _wbui; }
    bec::GRTManager *get_grt_manager();
    
    Db_sql_editor* get_active_sql_editor();

    bool activate_live_object(GrtObjectRef object);
    bool create_live_object(GrtObjectRef object_type, std::string owner_name, std::string obj_name);
    bool drop_live_object(GrtObjectRef object_type, std::string owner_name, std::string obj_name);
    void start_search_replace();

    void open_document(const std::string &path);
  private:
    mforms::SearchReplace* _search_replace_dialog;

    void active_form_changed(bec::UIForm *form);
  };
};
                      
#endif
