#include "stdafx.h"

#include "wb_overview_live_physical_schema.h"
#include "wb_overview_live_physical.h"


using namespace bec;
using namespace wb;
using namespace wb::internal;


LivePhysicalSchemaNode::LivePhysicalSchemaNode(db_SchemaRef schema)
: PhysicalSchemaNode(schema)
{
  _is_routine_group_enabled= false;
}


bool LivePhysicalSchemaNode::is_pasteable(bec::Clipboard *clip)
{
  return false;
}


void LivePhysicalSchemaNode::paste_object(WBContext *wb, bec::Clipboard *clip)
{
}


bool LivePhysicalSchemaNode::is_deletable()
{
  return false;
}


void LivePhysicalSchemaNode::delete_object(WBContext *wb)
{
  wb->drop_live_object(db_SchemaRef(object.get_grt()), "", *object->name());
}


bool LivePhysicalSchemaNode::activate(WBContext *wb)
{
  wb->activate_live_object(object);
  return true;
}


void LivePhysicalSchemaNode::focus(OverviewBE *sender)
{
  db_SchemaRef schema(db_SchemaRef::cast_from(object));
  LivePhysicalOverviewBE *live_physical_overview= dynamic_cast <LivePhysicalOverviewBE*> (sender);
  if (live_physical_overview)
    live_physical_overview->load_schema_contents(schema);
  db_CatalogRef::cast_from(schema->owner())->defaultSchema(schema);
}


bool LivePhysicalSchemaNode::add_new_db_table(WBContext *wb)
{
  return wb->create_live_object(db_TableRef(object.get_grt()), *object->name(), "");
}


bool LivePhysicalSchemaNode::add_new_db_view(WBContext *wb)
{
  return wb->create_live_object(db_ViewRef(object.get_grt()), *object->name(), "");
}


bool LivePhysicalSchemaNode::add_new_db_routine_group(WBContext *wb)
{
  return false;
}


bool LivePhysicalSchemaNode::add_new_db_routine(WBContext *wb)
{
  return wb->create_live_object(db_RoutineRef(object.get_grt()), *object->name(), "");
}


SchemaObjectNode * LivePhysicalSchemaNode::create_table_node(const db_DatabaseObjectRef &dbobject)
{
  return new LiveSchemaTableNode(dbobject);
}


SchemaObjectNode * LivePhysicalSchemaNode::create_view_node(const db_DatabaseObjectRef &dbobject)
{
  return new LiveSchemaViewNode(dbobject);
}


SchemaObjectNode * LivePhysicalSchemaNode::create_routine_node(const db_DatabaseObjectRef &dbobject)
{
  return new LiveSchemaRoutineNode(dbobject);
}


SchemaObjectNode * LivePhysicalSchemaNode::create_routine_group_node(const db_DatabaseObjectRef &dbobject)
{
  return new LiveSchemaRoutineGroupNode(dbobject);
}
