/* 
 * (c) 2007-2008 MySQL AB, 2008-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"


#include "editor_schema.h"
#include "string_utilities.h"

/**
 * @file  editor_schema.cpp
 * @brief 
 */

using namespace grt;
using namespace bec;
using namespace base;

SchemaEditorBE::SchemaEditorBE(GRTManager *grtm, const db_SchemaRef &schema, const db_mgmt_RdbmsRef &rdbms)
  : DBObjectEditorBE(grtm, schema, rdbms), _schema(schema)
{
}


void SchemaEditorBE::set_name(const std::string &name)
{
  if (is_editing_live_object() && get_schema()->oldName() != "")
    return;
  DBObjectEditorBE::set_name(name);
}


void SchemaEditorBE::set_schema_option_by_name(const std::string& name, const std::string& value)
{
  if(name.compare("CHARACTER SET - COLLATE") == 0)
  { // shortcut that sets both CHARACTER SET and COLLATE separated by a - 
    if (value != get_schema_option_by_name(name))
    {
      std::string charset, collation;
      parse_charset_collation(value, charset, collation);
      if (charset != *_schema->defaultCharacterSetName() || collation != *_schema->defaultCollationName())
      {
        block_auto_refresh();
        //grt::AutoUndo undo(get_grt());
        AutoUndoEdit undo(this);
        set_schema_option_by_name("CHARACTER SET", charset);
        set_schema_option_by_name("COLLATE", collation);
        update_change_date();
        undo.end(strfmt(_("Change Charset/Collation for '%s'"), _schema->name().c_str()));
        unblock_auto_refresh();
      }
    }
  }
  else if(name.compare("CHARACTER SET") == 0)
  {
    //grt::AutoUndo undo(get_grt());
    AutoUndoEdit undo(this);

    get_schema()->defaultCharacterSetName(value);
    update_change_date();

    undo.end(strfmt(_("Set Default Character Set for Schema '%s'"), get_name().c_str()));
  }
  else if(name.compare("COLLATE") == 0)
  {
    //grt::AutoUndo undo(get_grt());
    AutoUndoEdit undo(this);

    get_schema()->defaultCollationName(grt::StringRef(value));
    update_change_date();

    undo.end(strfmt(_("Set Default Collation for Schema '%s'"), get_name().c_str()));
  }
}

std::string SchemaEditorBE::get_schema_option_by_name(const std::string& name)
{
  if(name.compare("CHARACTER SET") == 0)
    return get_schema()->defaultCharacterSetName();
  else if(name.compare("COLLATE") == 0)
    return get_schema()->defaultCollationName();
  else if(name.compare("CHARACTER SET - COLLATE") == 0)
    return format_charset_collation(get_schema()->defaultCharacterSetName(), 
                                    get_schema()->defaultCollationName());
    
  return std::string();
}
