/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _EDITOR_SCHEMA_H_
#define _EDITOR_SCHEMA_H_

#include "grtdb/editor_dbobject.h"
#include "wbpublic_public_interface.h"

namespace bec {

  class WBPUBLICBACKEND_PUBLIC_FUNC SchemaEditorBE : public DBObjectEditorBE
  {
  protected:
    db_SchemaRef _schema;
  public:
    virtual db_DatabaseObjectRef get_dbobject() { return get_schema(); }
    virtual db_SchemaRef& get_schema() { return _schema; }

    virtual void set_name(const std::string &name);

    // table options
    virtual void set_schema_option_by_name(const std::string& name, const std::string& value);
    virtual std::string get_schema_option_by_name(const std::string& name);

    SchemaEditorBE(GRTManager *grtm, const db_SchemaRef &schema, const db_mgmt_RdbmsRef &rdbms);
  };

};


#endif /* _EDITOR_SCHEMA_H_ */
