/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include "stdafx.h"

#include "sql_specifics.h"


Sql_specifics::Sql_specifics(grt::GRT *grt)
:
_grt(grt)
{
}


std::string Sql_specifics::limit_select_query(const std::string &sql, int &row_count, int &offset)
{
  // since there is no standart syntax do-nothing by default
  return sql;
}


void Sql_specifics::get_connection_startup_script(std::list<std::string> &sql_script)
{
}


std::string Sql_specifics::query_connection_id()
{
  return "";
}


std::string Sql_specifics::query_kill_connection(int connection_id)
{
  return "";
}


sqlide::QuoteVar::Escape_sql_string Sql_specifics::escape_sql_string()
{
  return &sqlide::QuoteVar::escape_ansi_sql_string;
}


std::string Sql_specifics::setting_non_std_sql_delimiter()
{
  return "";
}


std::string Sql_specifics::non_std_sql_delimiter()
{
  return ";";
}
