/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef _SQL_SPECIFICS_H_
#define _SQL_SPECIFICS_H_


#include "wbpublic_public_interface.h"
#include "sqlide/sqlide_generics.h"
#include <grtpp.h>
#include <boost/shared_ptr.hpp>
#include <list>
#include <string>


/**
 * Defines interface to generalize above DBMS SQL specifics.
 * 
 * @ingroup sqlparser
 */
class WBPUBLICBACKEND_PUBLIC_FUNC Sql_specifics
{
public:
  typedef boost::shared_ptr<Sql_specifics> Ref;
  virtual ~Sql_specifics() {}
protected:
  Sql_specifics(grt::GRT *grt);

protected:
  grt::GRT *_grt;

public:
  virtual std::string limit_select_query(const std::string &sql, int &row_count, int &offset);
  virtual void get_connection_startup_script(std::list<std::string> &sql_script);
  virtual std::string query_connection_id();
  virtual std::string query_kill_connection(int connection_id);
  virtual sqlide::QuoteVar::Escape_sql_string escape_sql_string();
  virtual std::string setting_non_std_sql_delimiter();
  virtual std::string non_std_sql_delimiter();
};


#endif // _SQL_SPECIFICS_H_
