/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __STRING_LIST_EDITOR__H__
#define __STRING_LIST_EDITOR__H__

#include <mforms/mforms.h>

#include "wbpublic_public_interface.h"
#include "grtpp.h"

namespace grtui {

class WBPUBLICBACKEND_PUBLIC_FUNC StringListEditor : public mforms::Form 
{
protected:
  grt::GRT *_grt;
  
  mforms::Box _vbox;
  mforms::TreeView _tree;
  mforms::Box _button_box;
  mforms::Button _ok_button;
  mforms::Button _cancel_button;

  mforms::Button _add_button;
  mforms::Button _del_button;

  virtual void add();
  virtual void del();
  
public:
  StringListEditor(grt::GRT *grt, mforms::Form *owner= 0, const bool reorderable= false);
  
  bool run();

  void set_string_list(const std::vector<std::string> &strings);
  void set_grt_string_list(const grt::StringListRef &strings);

  std::vector<std::string> get_string_list();
  grt::StringListRef get_grt_string_list();
};

};

#endif


