/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _TEXT_INPUT_DIALOG_H_
#define _TEXT_INPUT_DIALOG_H_

#include <mforms/mforms.h>
#include "wbpublic_public_interface.h"

namespace grtui
{
  class WBPUBLICBACKEND_PUBLIC_FUNC TextInputDialog : public mforms::Form
  {
  public:
    TextInputDialog(mforms::Form *owner);

    void set_description(const std::string &text);
    void set_caption(const std::string &text);

    void set_value(const std::string &text);
    std::string get_value();

    bool run();

  protected:
    mforms::Table _table;
    mforms::Label _description;
    mforms::Label _caption;
    mforms::TextEntry _input;
    mforms::Box _button_box;
    mforms::Button _ok_button;
    mforms::Button _cancel_button;
  };
};


#endif /* _TEXT_INPUT_DIALOG_H_ */
