/* 
 * (c) 2007-2008 MySQL AB, 2008-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "stdafx.h"

#include "wizard_finished_page.h"
#include "grt/common.h"
#include "string_utilities.h"

using namespace grtui;

WizardFinishedPage::WizardFinishedPage(WizardForm *form, const std::string &top_title)
  : WizardPage(form, "finish")
{
  set_short_title(_("Results"));
  
  _label1.set_style(mforms::BoldStyle);
  _label1.set_wrap_text(true);

  set_spacing(12);
  set_padding(24);
  
  _top_title= top_title;
  _label2.set_text_align(mforms::TopLeft);
  _label2.set_wrap_text(true);
  
  _label1.set_text("");
  _label2.set_text("");

  add(&_label1, false, true);
  add(&_label2, true, true);
}



void WizardFinishedPage::set_heading(const std::string &title)
{
  _label1.set_text(title);
}


void WizardFinishedPage::set_summary(const std::string &text)
{
  _label2.set_text(text);
}


std::string WizardFinishedPage::next_button_caption()
{
#ifdef __APPLE__
  return _("Close");
#elif defined(_WIN32)
  return _("Finish");
#else
  return _("_Close");
#endif
}
