/* 
 * � 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"

#include "wizard_object_filter_page.h"
/**
 * @file  wizard_object_filter_page.cpp
 * @brief 
 */

using namespace grtui;


WizardObjectFilterPage::WizardObjectFilterPage(WizardForm *form, const char *name)
  : WizardPage(form, name), _scroll_panel(false), _box(false), _filter_be(form->grtm())
{
  set_padding(8);
  set_spacing(8);
  add(&_top_label, false, true);
  add(&_scroll_panel, true, true);
  _scroll_panel.add(&_box);
}


WizardObjectFilterPage::~WizardObjectFilterPage()
{
  reset();
}


DBObjectFilterFrame *WizardObjectFilterPage::add_filter(const std::string &class_name,
                                       const std::string &caption_fmt,
                                       bec::GrtStringListModel *model,
                                       bec::GrtStringListModel *excl_model)
{
  DBObjectFilterFrame *filter;
    
  filter= new DBObjectFilterFrame(_form->grtm());
  filter->set_object_class(class_name, caption_fmt);
  filter->set_models(model, excl_model);
  _box.add(mforms::manage(filter), false, true);
  _filters.push_back(filter);
//  filter->set_active(true);

  return filter;
}



void WizardObjectFilterPage::reset()
{
  for (std::vector<DBObjectFilterFrame*>::const_iterator iter= _filters.begin();
       iter != _filters.end(); ++iter)
  {
    _box.remove(*iter);
    (*iter)->release();
  }
  _filters.clear();
}

