/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "stdafx.h"

#include "base_bridge.h"
#include "grt/grt_manager.h"

/**
 * @file  base_bridge.cpp
 * @brief 
 */


bool BridgeBase::is_main_thread()
{
  return bec::GRTManager::get_instance_for(get_object()->get_grt())->in_main_thread();
}


void BridgeBase::run_later(const sigc::slot<void> &slot)
{
  bec::GRTManager::get_instance_for(get_object()->get_grt())->run_when_idle(sigc::bind_return(slot,false));
}


void BridgeBase::run_later(grt::GRT *grt, const sigc::slot<void> &slot)
{
  bec::GRTManager::get_instance_for(grt)->run_when_idle(sigc::bind_return(slot,false));
}
