/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"

#include "model_object_impl.h"
#include "model_diagram_impl.h"


void model_Object::ImplData::notify_realized()
{
  model_DiagramRef::cast_from(_self->owner())->get_data()->notify_object_realize(_self);
}


void model_Object::ImplData::set_in_view(bool flag) 
{
  _in_view= flag; 
  if (flag) 
    try_realize(); 
  else
    unrealize();
}


bool model_Object::ImplData::try_realize()
{
  if (is_realizable())
  {
    realize();
    return true;
  }
  return false;
}


void model_Object::ImplData::highlight(const mdc::Color *color)
{
  if (get_canvas_item())
  {
    get_canvas_item()->set_highlight_color(color);
    get_canvas_item()->set_highlighted(true);
  }
}


void model_Object::ImplData::unhighlight()
{
  if (get_canvas_item())
    get_canvas_item()->set_highlighted(false);
}

