/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"

#include "note_figure.h"

using namespace wbfig;

Note::Note(mdc::Layer *layer, FigureEventHub *hub, const model_ObjectRef &self)
: BaseFigure(layer, hub, self), _text(layer)
{
  set_allowed_resizing(true, true);
  set_accepts_focus(true);
  set_accepts_selection(true);
  set_auto_sizing(true);

  set_border_color(mdc::Color(0.5,0.5,0.5, 0.2));
  set_background_color(mdc::Color::White());
  set_draw_background(true);

  _text.set_padding(8, 8);
  _text.set_font(mdc::FontSpec(DEFAULT_FONT_FACE, mdc::SNormal, mdc::WNormal, 11));
  _text.set_pen_color(mdc::Color::Black());
  _text.set_multi_line(true);

  add(&_text, false, false, true);
}


Note::~Note()
{
}


void Note::set_text(const std::string &text)
{
  _text.set_text(text);
  set_needs_relayout();
}


void Note::set_text_color(const mdc::Color &color)
{
  _text.set_pen_color(color);
}


void Note::set_content_font(const mdc::FontSpec &font)
{
  _text.set_font(font);
  set_needs_relayout();
}


bool Note::on_click(mdc::CanvasItem *target, const mdc::Point &point, mdc::MouseButton button, mdc::EventState state)
{
  if (!_hub->figure_click(represented_object(), target, point, button, state))
    return super::on_click(target, point, button, state);
  return false;
}
