/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __NOTE_FIGURE_H__
#define __NOTE_FIGURE_H__

#include "figure_common.h"
#include "wbpublic_public_interface.h"


namespace wbfig {

  class WBPUBLICBACKEND_PUBLIC_FUNC Note : public BaseFigure
  {
    typedef BaseFigure super;
    mdc::TextFigure _text;

    virtual bool on_click(mdc::CanvasItem *target, const mdc::Point &point, mdc::MouseButton button, mdc::EventState state);
    
  public:
    Note(mdc::Layer *layer, FigureEventHub *hub, const model_ObjectRef &self);
    virtual ~Note();

    void set_text_color(const mdc::Color &color);
    void set_text(const std::string &text);

    virtual void set_content_font(const mdc::FontSpec &font);
  };
  
  
};

#endif

