/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __VIEW_FIGURE_H__
#define __VIEW_FIGURE_H__

#include "figure_common.h"
#include "wbpublic_public_interface.h"

namespace wbbridge { namespace physical { class ViewFigure; }; };

namespace wbfig {

  class WBPUBLICBACKEND_PUBLIC_FUNC View : public BaseFigure
  {
    friend class wbbridge::physical::ViewFigure;

    Titlebar _title;

  public:
    View(mdc::Layer *layer, FigureEventHub *hub, const model_ObjectRef &self);
    virtual ~View();
    
    virtual void set_color(const mdc::Color &color);
    void set_title(const std::string &title);

    virtual void set_title_font(const std::string &font);

    Titlebar *get_title() { return &_title; }
  };
  
  
};

#endif

