/* 
 * © 2007-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"
#include "workbench_model_notefigure_impl.h"

#include "model_layer_impl.h"
#include "model_diagram_impl.h"


workbench_model_NoteFigure::ImplData::ImplData(workbench_model_NoteFigure *self)
  : super(self), _figure(0)
{
  _resizable= true;
}


void workbench_model_NoteFigure::ImplData::set_text(const std::string &text)
{
  self()->_text= text;
  
  if (_figure)
  {
    _figure->set_text(text);
    
    mdc::Size min_size= _figure->get_min_size();
    mdc::Size size= _figure->get_size();
    if (min_size.width > size.width)
      size.width= min_size.width;
    if (min_size.height > size.height)
      size.height= min_size.height;
    if (size != _figure->get_size())
    {
      if (*self()->_manualSizing)
        get_canvas_item()->set_fixed_size(size);
      else
        get_canvas_item()->resize_to(size);
      
      figure_bounds_changed(_figure->get_bounds());
    }
  }
}


void workbench_model_NoteFigure::ImplData::unrealize()
{
  super::unrealize();
  
  delete _figure;
  _figure= 0;
}



bool workbench_model_NoteFigure::ImplData::realize()
{
  if (_figure) return true;
  if (!is_realizable()) return false;
  
  if (!is_main_thread())
  {
    run_later(sigc::hide_return(sigc::mem_fun(this, &ImplData::realize)));
    return true;
  }

  if (!_figure)
  {
    mdc::CanvasView *view= self()->owner()->get_data()->get_canvas_view();
    mdc::AreaGroup *agroup;
  
    view->lock();
    
    wbfig::Note *note= _figure= new wbfig::Note(view->get_current_layer(), self()->owner()->get_data(), self());
    note->set_text(self()->_text);

    agroup= self()->layer()->get_data()->get_area_group();
    
    view->get_current_layer()->add_item(_figure, agroup);
    
    _figure->set_color(mdc::Color::parse(*self()->_color));

    finish_realize();
    
    view->unlock();

    self()->owner()->get_data()->notify_object_realize(self());
  }
  return true;
}
