/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __DB_SQL_EDITOR_HISTORY_WR_H__
#define __DB_SQL_EDITOR_HISTORY_WR_H__


#include "sqlide/db_sql_editor_history_be.h"


namespace MySQL {
namespace GUI {
namespace Workbench {


using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;
using namespace MySQL::Grt;
using namespace MySQL::Grt::Db;
using namespace MySQL::Grt::Db::Sql;


public ref class DbSqlEditorHistory
{
public:
  typedef ManagedRef<::DbSqlEditorHistory> ^ Ref;
  DbSqlEditorHistory(Ref ref);
  Ref ref() { return _ref; }
private:
  Ref _ref;

public:
  VarGridModel ^ entries_model() { return _entries_model; }
  VarGridModel ^ details_model() { return _details_model; }
private:
  VarGridModel ^_entries_model;
  VarGridModel ^_details_model;

public:
  void current_entry(int index) { _ref->current_entry(index); }
};


};  // namespace Workbench
};  // namespace GUI
};  // namespace MySQL


#endif // __DB_SQL_EDITOR_HISTORY_WR_H__
