/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __DB_SQL_EDITOR_WR_H__
#define __DB_SQL_EDITOR_WR_H__

#include "sqlide/wb_sql_editor_form.h"

#include "db_sql_editor_history_wr.h"
#include "Overview.h"

namespace MySQL {
namespace GUI {
namespace Workbench {


using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;
using namespace MySQL::Grt;
using namespace MySQL::Grt::Db;
using namespace MySQL::Grt::Db::Sql;


public ref class Db_sql_editor : public UIForm
{
public:
  typedef ManagedRef<::Db_sql_editor> ^ Ref;
  //!Db_sql_editor(MySQL::Grt::GrtManager ^grt_manager, MySQL::Grt::GrtValue ^grt_list);
  Db_sql_editor(IntPtr ptr);
  Ref ref() { return _ref; }
private:
  Ref _ref;
public:
  void destroy();

public:
  GrtManager ^ grt_manager() { return gcnew GrtManager(_ref->grt_manager()); }
  Sql::Sql_editor ^ sql_editor() { return Ref2Ptr_<::Sql_editor, Sql::Sql_editor>(_ref->sql_editor()); }
  Sql::Sql_editor ^ sql_editor(int index) { return Ref2Ptr_<::Sql_editor, Sql::Sql_editor>(_ref->sql_editor(index)); }
  int sql_editor_count() { return _ref->sql_editor_count(); }
  int add_sql_editor() { return _ref->add_sql_editor(); }
  void remove_sql_editor(int index) { return _ref->remove_sql_editor(index); }
  int active_sql_editor_index() { return _ref->active_sql_editor_index(); }
  void active_sql_editor_index(int val) { _ref->active_sql_editor_index(val); }

  String ^ caption() { return CppStringToNative(_ref->caption()); }

  //!void stored_connections(List<String^> ^stored_connections_ids, List<String^> ^stored_connections_names);
  //!String ^ stored_connection() { return CppStringToNative(_ref->stored_connection()); }
  //!void stored_connection(String ^guid) { _ref->stored_connection(NativeToCppString(guid)); }
  //!void show_connection_editor() { _ref->show_connection_editor(); }

  String ^ connection_info() { return CppStringToNative(_ref->connection_info()); }

  void connect() { _ref->connect(); }
  bool connected() { return _ref->connected(); }
  //!void disconnect() { _ref->disconnect(); }
  void cancel_query() { _ref->cancel_query(); }

  void reset() { _ref->reset(); }
  void exec_sql(String ^sql, bool wrap_with_non_std_delimiter) { _ref->exec_sql(NativeToCppString(sql), false, wrap_with_non_std_delimiter); }
  void commit() { _ref->commit(); }
  void rollback() { _ref->rollback(); }
  int recordset_count() { return _ref->recordset_count(); }
  Recordset ^ recordset(int index);

public:
  VarGridModel ^ log() { return _log; }
  DbSqlEditorHistory ^ history() { return _history; }
  String ^ restore_sql_from_history(int entry_index, List<int> ^detail_indexes);
private:
  VarGridModel ^_log;
  DbSqlEditorHistory ^_history;

public:
  void get_log_event_details(int log_event_no, [Out] int %log_event_type_code, [Out] String^ %log_event_time, [Out] String^ %log_event_action, [Out] String^ %log_event_message);

public:
  bool recordsets_are_pinned_by_default() { return _ref->recordsets_are_pinned_by_default(); }
  void recordsets_are_pinned_by_default(bool value) { _ref->recordsets_are_pinned_by_default(value); }

public:
  bool can_close() { return _ref->can_close(); }

public:
  List<String^>^ schemata();
  void active_schema(String ^schema) { _ref->active_schema(NativeToCppString(schema)); }
  String ^ active_schema() { return CppStringToNative(_ref->active_schema()); }
  int active_schema_index() { return _ref->active_schema_index(); }

public:
  //!List<String^>^ tables();
  //!void active_table(String ^table) { _ref->active_table(NativeToCppString(table)); }
  //!String ^ active_table() { return CppStringToNative(_ref->active_table()); }
  //!String ^ active_table_query() { return CppStringToNative(_ref->active_table_query()); }

public:
  //!List<String^>^ views();
  //!void active_view(String ^view) { _ref->active_view(NativeToCppString(view)); }
  //!String ^ active_view() { return CppStringToNative(_ref->active_view()); }
  //!String ^ active_view_query() { return CppStringToNative(_ref->active_view_query()); }

public:
  ::MySQL::Workbench::Overview ^live_physical_overview();
private:
  ::MySQL::Workbench::Overview ^_live_physical_overview;

public:
  GrtThreadedTask ^exec_sql_task;

private:
  RefreshUI ^_refresh_ui;
public:
  RefreshUI ^refresh_ui() { return _refresh_ui; }

  enum class PartialRefreshType
  {
    RefreshSidebar= ::Db_sql_editor::RefreshSidebar, // update the sidebar
    RefreshSchemaTree= ::Db_sql_editor::RefreshSchemaTree, // refresh live schema tree
    RefreshEditor= ::Db_sql_editor::RefreshEditor, // refresh the text editor using data from backend
    RefreshSnippets= ::Db_sql_editor::RefreshSnippets,
    RefreshSnippetCollections= ::Db_sql_editor::RefreshSnippetCollections,
    RunCurrentScript= ::Db_sql_editor::RunCurrentScript
  };

public:
  TreeModel ^ schema_tree() { return gcnew TreeModel(_ref->get_schema_tree()); }
  //!void request_refresh_schema_tree() { return _ref->request_refresh_schema_tree(); }

public:
  typedef DelegateSlot1<int, int,
    long long, long long> Close_recordset_ui_cb;
  void close_recordset_ui_cb(Close_recordset_ui_cb::ManagedDelegate ^cb);
private:
  Close_recordset_ui_cb ^_close_recordset_ui_cb;

public:
  typedef DelegateSlot1<int, int,
    int, int> Sql_editor_new_ui_cb;
  void sql_editor_new_ui_cb(Sql_editor_new_ui_cb::ManagedDelegate ^cb);
private:
  Sql_editor_new_ui_cb ^_sql_editor_new_ui_cb;

public:
  typedef DelegateSlot1<int, int,
    std::string, String^> Sql_editor_caption_ui_cb;
  void sql_editor_caption_ui_cb(Sql_editor_caption_ui_cb::ManagedDelegate ^cb);
private:
  Sql_editor_caption_ui_cb ^_sql_editor_caption_ui_cb;

public:
  typedef DelegateSlot1<int, int,
    std::string, String^> Sql_editor_text_insert_cb;
  void sql_editor_text_insert_cb(Sql_editor_text_insert_cb::ManagedDelegate ^cb);
private:
  Sql_editor_text_insert_cb ^_sql_editor_text_insert_cb;

public:
  typedef DelegateSlot0<int, int> Call_command_cb;
  typedef DelegateSlot0<bool, bool> Validate_command_cb;

#define COMMAND_CALL_VALIDATE_CB(cmd) \
public:\
  void validate_ ## cmd ## _cb(Validate_command_cb::ManagedDelegate ^cb) {\
    _validate_ ## cmd ## _cb= gcnew Validate_command_cb(cb);\
    _ref->validate_ ## cmd ## _cb(_validate_ ## cmd ## _cb->get_slot());\
  }\
  void call_ ## cmd ## _cb(Call_command_cb::ManagedDelegate ^cb) {\
    _call_ ## cmd ## _cb= gcnew Call_command_cb(cb);\
    _ref->call_ ## cmd ## _cb(_call_ ## cmd ## _cb->get_slot());\
  }\
private:\
  Call_command_cb ^_call_ ## cmd ## _cb;\
  Validate_command_cb ^_validate_ ## cmd ## _cb;

COMMAND_CALL_VALIDATE_CB(exec_sql)
COMMAND_CALL_VALIDATE_CB(exec_current_sql_statement)
COMMAND_CALL_VALIDATE_CB(save_edits)
COMMAND_CALL_VALIDATE_CB(discard_edits)

#undef COMMAND_CALL_VALIDATE_CB
};


};  // namespace Workbench
};  // namespace GUI
};  // namespace MySQL


#endif // __DB_SQL_EDITOR_WR_H__
