/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include "stdafx.h"

#include "Grt.h"
#include "GrtTemplates.h"
#include "sql_editor_wr.h"
#include "recordset_wr.h"


namespace MySQL {
namespace Grt {
namespace Db {
namespace Sql {


using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;


int Sql_editor::int_option(String ^name)
{
  return _ref->int_option(NativeToCppString(name));
}


String ^ Sql_editor::string_option(String ^name)
{
  return CppStringToNative(_ref->string_option(NativeToCppString(name)));
}


void Sql_editor::get_sql_statement_border_by_line_pos(int lineno, int line_pos, int %stmt_begin_lineno, int %stmt_begin_line_pos, int %stmt_end_lineno, int %stmt_end_line_pos)
{
  ::Sql_editor::SqlStatementBorder sql_statement_border= _ref->get_sql_statement_border_by_line_pos(lineno, line_pos);
  stmt_begin_lineno= sql_statement_border.begin_lineno;
  stmt_begin_line_pos= sql_statement_border.begin_line_pos;
  stmt_end_lineno= sql_statement_border.end_lineno;
  stmt_end_line_pos= sql_statement_border.end_line_pos;
}


};  // namespace Sql
};  // namespace Db
};  // namespace Grt
};  // namespace MySQL
