/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __SQL_EDITOR_WR_H__
#define __SQL_EDITOR_WR_H__


#include "sqlide/sql_editor_be.h"
#include "GrtTemplates.h" // reference in stdafx.h is not enough because stdafx.h has subdir only effect
#include "SigCSlot.h" // reference in stdafx.h is not enough because stdafx.h has subdir only effect
#include "forms/dialogs/search_replace.h"


using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;


namespace MySQL {
namespace Grt {
namespace Db {
namespace Sql {


ref class Recordset;


public ref class Sql_editor
{
public:
  typedef ManagedRef<::Sql_editor> ^ Ref;
  Sql_editor(Ref ref) : _ref(ref) {}
  Sql_editor(IntPtr nref_ptr) : _ref(gcnew ManagedRef<::Sql_editor>(nref_ptr)) {}
  Ref ref() { return _ref; }
private:
  Ref _ref;

public:
  void destroy() { ~_ref; }

public:
  int int_option(String ^name);
  String ^ string_option(String ^name);

public:
  void sql(String ^sql) { _ref->sql(NativeToCppString(sql)); }
  String ^ sql() { return CppStringToNative(_ref->sql()); }

public:
  bool is_refresh_enabled() { return _ref->is_refresh_enabled(); }
  void is_refresh_enabled(bool val) { _ref->is_refresh_enabled(val); }
  bool is_sql_check_enabled() { return _ref->is_sql_check_enabled(); }
  void is_sql_check_enabled(bool val) { _ref->is_sql_check_enabled(val); }

public:
  void set_selected_range(int start, int end)
  {
    _ref->set_selected_range(start, end);
  }

  void set_cursor_pos(int pos)
  {
    _ref->set_cursor_pos(pos);
  }

public:
  typedef DelegateSlot1<
    int, int,
    std::string, String^> InsertReplaceTextDelegate;
  void set_replace_selected_text_delegate(InsertReplaceTextDelegate::ManagedDelegate ^cb)
  {
    _replace_selected_text_delegate= gcnew InsertReplaceTextDelegate(cb);
    _ref->replace_selected_text_slot= _replace_selected_text_delegate->get_slot();
  }
  void set_insert_text_delegate(InsertReplaceTextDelegate::ManagedDelegate ^cb)
  {
    _insert_text_delegate= gcnew InsertReplaceTextDelegate(cb);
    _ref->insert_text_slot= _insert_text_delegate->get_slot();
  }
private:
  InsertReplaceTextDelegate^ _replace_selected_text_delegate;
  InsertReplaceTextDelegate^ _insert_text_delegate;

public:
  typedef DelegateSlot0<
    std::string, String^> TextPropertyDelegate;
  void set_current_statement_delegate(TextPropertyDelegate::ManagedDelegate ^cb)
  {
    _current_statement_delegate= gcnew TextPropertyDelegate(cb);
    _ref->current_statement_slot= _current_statement_delegate->get_slot();
  }
private:
  TextPropertyDelegate^ _current_statement_delegate;

public:
  // TODO: move this to a generic base wrapper.
  enum class SearchFlags
  {
    SearchNone= mforms::SearchNone,
    SearchMatchCase= mforms::SearchMatchCase,
    SearchMatchWholeWord=mforms::SearchMatchWholeWord,
    SearchUseRegularExpression=mforms::SearchUseRegularExpression,
    SearchDoReplace=mforms::SearchDoReplace,
    SearchAll=mforms::SearchAll,
    SearchPrevious=mforms::SearchPrevious,
  }; 

  typedef DelegateSlot3<
    bool, bool,
    std::string, String^,
    std::string, String^,
    int, int> DoSearchDelegate;

  void set_do_seach_delegate(DoSearchDelegate::ManagedDelegate ^cb)
  {
    _do_search_delegate= gcnew DoSearchDelegate(cb);
    _ref->do_search_slot= _do_search_delegate->get_slot();
  }
private:
  DoSearchDelegate^ _do_search_delegate;

public:
  void check_sql(bool sync) { _ref->check_sql(&_ref, sync); }

  typedef DelegateSlot4<
    int, int,
    int, int,
    int, int,
    int, int,
    std::string, String^> ParseErrorDelegate;

  void sql_parser_err_cb(ParseErrorDelegate::ManagedDelegate ^cb)
  {
    on_parse_err_delegate= gcnew ParseErrorDelegate(cb);
    _ref->sql_parser_err_cb(on_parse_err_delegate->get_slot());
  }
private:
  ParseErrorDelegate^ on_parse_err_delegate;

public:
  typedef DelegateSlot4<
    int, int,
    int, int,
    int, int,
    int, int,
    int, int> ReportSqlStatementBordersDelegate;

  void set_report_sql_statement_border_delegate(ReportSqlStatementBordersDelegate::ManagedDelegate ^cb)
  {
    on_report_sql_statement_border_delegate= gcnew ReportSqlStatementBordersDelegate(cb);
    _ref->report_sql_statement_border= on_report_sql_statement_border_delegate->get_slot();
  }
private:
  ReportSqlStatementBordersDelegate^ on_report_sql_statement_border_delegate;

public:
  void get_sql_statement_border_by_line_pos(int lineno, int line_pos, int %begin_lineno, int %begin_line_pos, int %end_lineno, int %end_line_pos);
};


};  // namespace Sql
};  // namespace Db
};  // namespace Grt
};  // namespace MySQL


#endif // __SQL_EDITOR_WR_H__
