/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __VAR_GRID_MODEL_WR_H__
#define __VAR_GRID_MODEL_WR_H__


#include "sqlide/var_grid_model_be.h"
#include "GrtThreadedTask.h" // reference in stdafx.h is not enough because stdafx.h has subdir only effect


namespace MySQL {
namespace Grt {


using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;


public ref class VarGridModel : public MySQL::Grt::GridModel
{
public:
  typedef ManagedRef<::VarGridModel> ^ Ref;
  VarGridModel(Ref ref);
  VarGridModel(IntPtr nref_ptr);
  Ref ref() { return _ref; }
private:
  Ref _ref;

public:
  typedef DelegateSlot0<int, int> Refresh_ui_cb;
  void refresh_ui_cb(Refresh_ui_cb::ManagedDelegate ^cb);
private:
  Refresh_ui_cb ^_refresh_ui_cb;
};


};  // namespace Grt
};  // namespace MySQL


#endif // __VAR_GRID_MODEL_WR_H__
