#include "stdafx.h"

#include "Canvas.h"


mdc::EventState MySQL::GUI::Mdc::BaseWindowsCanvasView::getEventState(Keys keys, MouseButtons buttons)
{
  mdc::EventState state= ((mdc::EventState)0);

  if ((keys & Keys::Control) == Keys::Control)
    state= state | mdc::SControlMask;
  if ((keys & Keys::Shift) == Keys::Shift)
    state= state | mdc::SShiftMask;
  if ((keys & Keys::Alt) == Keys::Alt)
    state= state | mdc::SAltMask;

  if ((buttons & MouseButtons::Left) == MouseButtons::Left)
    state= state | mdc::SLeftButtonMask;
  if ((buttons & MouseButtons::Middle) == MouseButtons::Middle)
    state= state | mdc::SMiddleButtonMask;
  if ((buttons & MouseButtons::Right) == MouseButtons::Right)
    state= state | mdc::SRightButtonMask;

  return state;
}



mdc::KeyInfo MySQL::GUI::Mdc::BaseWindowsCanvasView::getKeyInfo(KeyEventArgs ^e)
{
  static KeyCodeMapping keycodes[]= {
    {Keys::Back,    mdc::KBackspace},
    {Keys::Delete,  mdc::KDelete},
    {Keys::Down,    mdc::KDown},
    {Keys::End,     mdc::KEnd},
    {Keys::Enter,   mdc::KEnter},
    {Keys::Escape,  mdc::KEscape},
    {Keys::F1,      mdc::KF1},
    {Keys::F2,      mdc::KF2},
    {Keys::F3,      mdc::KF3},
    {Keys::F4,      mdc::KF4},
    {Keys::F5,      mdc::KF5},
    {Keys::F6,      mdc::KF6},
    {Keys::F7,      mdc::KF7},
    {Keys::F8,      mdc::KF8},
    {Keys::F9,      mdc::KF9},
    {Keys::F10,     mdc::KF10},
    {Keys::F11,     mdc::KF11},
    {Keys::F12,     mdc::KF12},
    {Keys::Home,    mdc::KHome},
    {Keys::Insert,  mdc::KInsert},
    {Keys::Left,    mdc::KLeft},
    {Keys::Next,    mdc::KPageDown},
    {Keys::PageDown,mdc::KPageDown},
    {Keys::PageUp,  mdc::KPageUp},
    {Keys::Prior,   mdc::KPageUp},
    {Keys::Return,  mdc::KEnter},
    {Keys::Shift,   mdc::KShift},
    {Keys::Tab,     mdc::KTab},

    {Keys::Space,   mdc::KSpace},
    {Keys::OemPeriod, mdc::KPeriod},
    {Keys::Oemcomma,   mdc::KComma},
    {Keys::OemSemicolon, mdc::KSemicolon}
  };

  mdc::KeyInfo k;

  k.keycode= mdc::KNone;
  k.string= "";
  for (int i= 0; i < sizeof(keycodes)/sizeof(*keycodes); i++)
  {
    if (keycodes[i].key == e->KeyCode)
    {
      k.keycode= keycodes[i].kcode;
      break;
    }
  }

  if (k.keycode == 0)
  {
    KeysConverter^ c= gcnew KeysConverter();
    k.string= MySQL::NativeToCppString(c->ConvertToString(e->KeyCode));
  }

  return k;
}