/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include "stdafx.h"
#include "ActionList.h"

namespace MySQL {
namespace Grt {

ActionList::ActionList(::ActionList *inner)
:
_inner(inner),
_actions(gcnew Dictionary<String^, ActionCallback^>()),
_node_actions(gcnew Dictionary<String^, NodeActionCallback^>()),
_nodes_actions(gcnew Dictionary<String^, NodesActionCallback^>()),
_rows_col_actions(gcnew Dictionary<String^, RowsColActionCallback^>())
{
}

void ActionList::reset()
{
  _inner->reset();
  _actions->Clear();
  _node_actions->Clear();
  _nodes_actions->Clear();
  _rows_col_actions->Clear();
}

void ActionList::register_action(String ^name, ActionCallback::ManagedDelegate ^cb)
{
  ActionCallback ^actionCallback = gcnew ActionCallback(cb);
  _actions->Add(name, actionCallback);
  _inner->register_action(NativeToCppString(name), actionCallback->get_slot());
}

void ActionList::unregister_action(String ^name)
{
  _inner->unregister_action(NativeToCppString(name));
}

bool ActionList::trigger_action(String ^name)
{
  return _inner->trigger_action(NativeToCppString(name));
}

void ActionList::register_node_action(String ^name, NodeActionCallback::ManagedDelegate ^cb)
{
  NodeActionCallback ^actionCallback = gcnew NodeActionCallback(cb);
  _node_actions->Add(name, actionCallback);
  _inner->register_node_action(NativeToCppString(name), actionCallback->get_slot());
}

void ActionList::unregister_node_action(String ^name)
{
  return _inner->unregister_node_action(NativeToCppString(name));
}

bool ActionList::trigger_action(String ^name, NodeId ^node)
{
  return _inner->trigger_action(NativeToCppString(name), *node->get_unmanaged_object());
}

void ActionList::register_nodes_action(String ^name, NodesActionCallback::ManagedDelegate ^cb)
{
  NodesActionCallback ^actionCallback = gcnew NodesActionCallback(cb);
  _nodes_actions->Add(name, actionCallback);
  _inner->register_nodes_action(NativeToCppString(name), actionCallback->get_slot());
}

void ActionList::unregister_nodes_action(String ^name)
{
  return _inner->unregister_nodes_action(NativeToCppString(name));
}

bool ActionList::trigger_action(String ^name, List<NodeId^> ^nodes)
{
  return _inner->trigger_action(NativeToCppString(name), ObjectListToCppVector<NodeId, bec::NodeId>(nodes));
}

void ActionList::register_rows_col_action(String ^name, RowsColActionCallback::ManagedDelegate ^cb)
{
  RowsColActionCallback ^actionCallback = gcnew RowsColActionCallback(cb);
  _rows_col_actions->Add(name, actionCallback);
  _inner->register_rows_col_action(NativeToCppString(name), actionCallback->get_slot());
}

void ActionList::unregister_rows_col_action(String ^name)
{
  return _inner->unregister_rows_col_action(NativeToCppString(name));
}

bool ActionList::trigger_action(String ^name, List<int> ^rows, int column)
{
  return _inner->trigger_action(NativeToCppString(name), NativeListToCppVector<int, int>(rows), column);
}

}
}
