/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef __ACTION_LIST_WR_H__
#define __ACTION_LIST_WR_H__

#include "grt/action_list.h"
#include "SigCSlot.h"

namespace MySQL {
namespace Grt {

public ref class ActionList
{
public:
  ActionList(::ActionList *inner);
  void reset();
private:
  ::ActionList *_inner;

public:
  typedef DelegateSlot0<void, void> ActionCallback;
  void register_action(String ^name, ActionCallback::ManagedDelegate ^cb);
  void unregister_action(String ^name);
  bool trigger_action(String ^name);
private:
  Dictionary<String^, ActionCallback^>^ _actions;

public:
  typedef DelegateSlot1<void, void, bec::NodeId, NodeId^> NodeActionCallback;
  void register_node_action(String ^name, NodeActionCallback::ManagedDelegate ^cb);
  void unregister_node_action(String ^name);
  bool trigger_action(String ^name, NodeId ^node);
private:
  Dictionary<String^, NodeActionCallback^>^ _node_actions;

public:
  typedef DelegateSlot1<void, void, std::vector<bec::NodeId>, List<NodeId^>^> NodesActionCallback;
  void register_nodes_action(String ^name, NodesActionCallback::ManagedDelegate ^cb);
  void unregister_nodes_action(String ^name);
  bool trigger_action(String ^name, List<NodeId^>^ node);
private:
  Dictionary<String^, NodesActionCallback^>^ _nodes_actions;

public:
  typedef DelegateSlot2<void, void, std::vector<int>, List<int>^, int, int> RowsColActionCallback;
  void register_rows_col_action(String ^name, RowsColActionCallback::ManagedDelegate ^cb);
  void unregister_rows_col_action(String ^name);
  bool trigger_action(String ^name, List<int>^ rows, int column);
private:
  Dictionary<String^, RowsColActionCallback^>^ _rows_col_actions;
};

}
}

#endif
