#ifndef __BASE_EDITOR_H_
#define __BASE_EDITOR_H_

#include "grt/editor_base.h"
#include "sql_editor_wr.h"
#include "GrtTemplates.h"
#include "SigCSlot.h"
#include "UIForm.h"
#include "GrtManager.h"

#ifdef _MSC_VER
//#include  <vcclr.h> // .net interop helpers
using namespace MySQL::Grt;
using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;
#endif

#pragma make_public(::bec::BaseEditor)

namespace MySQL {
namespace Grt {


public ref class BaseEditor : public UIForm
{
public:
  delegate void VoidBaseEditorDelegate(BaseEditor ^value);

protected:

  typedef void (*BaseEditor::VOID_BASE_EDITOR_HANDLER_CB)(::bec::BaseEditor *editor);

  BaseEditor(::bec::BaseEditor *inn)
    : UIForm(inn)
  {}

  DelegateSlot0<void,void> ^refresh_ui_handler;
  DelegateSlot1<void,void,int,int> ^refresh_partial_ui_handler;
  //VoidBaseEditorDelegate^ add_unlocked_handler_delegate;

private:
  //delegate void VoidBaseEditorWrapperDelegate(::bec::BaseEditor *editor);

  //VoidBaseEditorWrapperDelegate^ add_unlocked_handler_wrapper_delegate;

 // void add_unlocked_handler_wrapper(::bec::BaseEditor *editor)
 // { add_unlocked_handler_delegate(gcnew BaseEditor(editor)); }

public:
  void disable_auto_refresh() { ((::bec::BaseEditor*)inner)->block_auto_refresh(); }
  void enable_auto_refresh()  { ((::bec::BaseEditor*)inner)->unblock_auto_refresh(); }

  ::bec::BaseEditor *get_unmanaged_object()
  { return static_cast<::bec::BaseEditor *>(inner); }

  //virtual GrtObject get_object()= 0;
  GrtValue^ get_object() 
  { return gcnew GrtValue(get_unmanaged_object()->get_object()); }

  bool is_editing_live_object()
  { return get_unmanaged_object()->is_editing_live_object(); }

  void apply_changes_to_live_object()
  { get_unmanaged_object()->apply_changes_to_live_object(); }

  void refresh_live_object()
  { get_unmanaged_object()->refresh_live_object(); }

  void add_refresh_ui_handler(DelegateSlot0<void,void>::ManagedDelegate^ slot)
  {
    refresh_ui_handler= gcnew DelegateSlot0<void,void>(slot);
    get_unmanaged_object()->set_refresh_ui_slot(refresh_ui_handler->get_slot());
  }

  void add_refresh_partial_ui_handler(DelegateSlot1<void,void,int,int>::ManagedDelegate^ slot)
  {
    refresh_partial_ui_handler= gcnew DelegateSlot1<void,void,int,int>(slot);
    get_unmanaged_object()->set_partial_refresh_ui_slot(refresh_partial_ui_handler->get_slot());
  }

  GRT^ get_grt() { return gcnew GRT(get_unmanaged_object()->get_grt()); }

  GrtManager^ get_grt_manager() { return gcnew GrtManager(get_unmanaged_object()->get_grt_manager()); }

  // for use by subclasses
  void show_exception(String ^title, String ^detail)
  {
    MessageBox::Show(String::Format("An error has occurred while performing the requested action:\n{0}", detail),
      title, MessageBoxButtons::OK, MessageBoxIcon::Error);
  }

  Db::Sql::Sql_editor ^ get_sql_editor() { return Ref2Ptr<::Sql_editor, Db::Sql::Sql_editor>(get_unmanaged_object()->get_sql_editor()); }

  void show_validation_error(String ^title, String ^reason)
  {
    MessageBox::Show(String::Format("Cannot change property:\n{0}", reason), 
      title, MessageBoxButtons::OK, MessageBoxIcon::Error);
  }

  bool should_close_on_delete_of(String ^oid)
  {
    return get_unmanaged_object()->should_close_on_delete_of(NativeToCppString(oid));
  }

public:
  typedef DelegateSlot3<
    int, int,
    long long, Int64,
    std::string, String^,
    std::string, String^> LiveObjectChangeErrorDelegate;
  void set_live_object_change_error_cb(LiveObjectChangeErrorDelegate::ManagedDelegate ^cb)
  {
    on_live_object_change_error_delegate= gcnew LiveObjectChangeErrorDelegate(cb);
    get_unmanaged_object()->on_live_object_change_error= on_live_object_change_error_delegate->get_slot();
  }
private:
  LiveObjectChangeErrorDelegate^ on_live_object_change_error_delegate;

public:
  typedef DelegateSlot1<
    int, int,
    float, float> LiveObjectChangeProgressDelegate;
  void set_live_object_change_progress_cb(LiveObjectChangeProgressDelegate::ManagedDelegate ^cb)
  {
    on_live_object_change_progress_delegate= gcnew LiveObjectChangeProgressDelegate(cb);
    get_unmanaged_object()->on_live_object_change_progress= on_live_object_change_progress_delegate->get_slot();
  }
private:
  LiveObjectChangeProgressDelegate^ on_live_object_change_progress_delegate;

public:
  typedef DelegateSlot2<
    int, int,
    int, int,
    int, int> LiveObjectChangeStatisticsDelegate;
  void set_live_object_change_statistics_cb(LiveObjectChangeStatisticsDelegate::ManagedDelegate ^cb)
  {
    on_live_object_change_statistics_delegate= gcnew LiveObjectChangeStatisticsDelegate(cb);
    get_unmanaged_object()->on_live_object_change_statistics= on_live_object_change_statistics_delegate->get_slot();
  }
private:
  LiveObjectChangeStatisticsDelegate^ on_live_object_change_statistics_delegate;
};


} // namespace Grt
} // namespace MySQL

#endif // __BASE_EDITOR_H_
