#ifndef __EXCEPTIONS_H__
#define __EXCEPTIONS_H__

#ifdef _MSC_VER
//#include  <vcclr.h> // .net interop helpers
using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections::Generic;
#endif


#include <sstream>

namespace MySQL {
namespace Grt {

public ref class BackendException : public System::Exception
{
//  std::exception *inner;
  String^ _message;

public:

  BackendException(std::exception *inn) : _message(CppStringToNative(inn->what()))
  {}

  BackendException(const std::exception &inn) : _message(CppStringToNative(inn.what()))
  {}

  BackendException(const char *message) : _message(CppStringToNative(message))
  {}

  BackendException(const std::string &message) : _message(CppStringToNative(message))
  {}

  virtual property String^ Message 
  {
    String^ get () override
    {
      return _message;
    }
  }
};

public ref class UnknownBackendException : public BackendException
{
  std::string itoa(int i)
  {
    std::stringstream ss;
    ss << i;
    std::string res= ss.str().c_str();
    return res;
  }
public:
  UnknownBackendException(const char* file, int line) : BackendException("Unknown Exception caught in " + std::string(file) + " at line " + itoa(line))
  {}
};

} // namespace Grt
} // namespace MySQL

#endif // __EXCEPTIONS_H__